/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.glow.plugin.arquillian.apache.surefire.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.wildfly.glow.plugin.arquillian.apache.surefire.testset.TestFilter;
import org.wildfly.glow.plugin.arquillian.apache.surefire.testset.TestListResolver;
import org.wildfly.glow.plugin.arquillian.apache.surefire.util.DefaultScanResult;
import org.wildfly.glow.plugin.arquillian.apache.surefire.util.ScannerUtil;

public class DependencyScanner {
    private final List<File> dependenciesToScan;
    private final TestListResolver filter;

    public DependencyScanner(List<File> dependenciesToScan, TestListResolver filter) {
        this.dependenciesToScan = dependenciesToScan;
        this.filter = filter;
    }

    public DefaultScanResult scan() throws MojoExecutionException {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        for (File artifact : this.dependenciesToScan) {
            if (artifact == null || !artifact.isFile() || !artifact.getName().endsWith(".jar")) continue;
            try {
                DependencyScanner.scanArtifact(artifact, this.filter, classes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not scan dependency " + artifact.toString(), (Exception)e);
            }
        }
        return new DefaultScanResult(new ArrayList<String>(classes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanArtifact(File artifact, TestFilter<String, String> filter, Set<String> classes) throws IOException {
        try (JarFile jar = null;){
            jar = new JarFile(artifact);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String path = entry.getName();
                if (entry.isDirectory() || !ScannerUtil.isJavaClassFile(path) || !filter.shouldRun(path, null)) continue;
                classes.add(ScannerUtil.convertJarFileResourceToJavaClassName(path));
            }
        }
    }

    public static List<Artifact> filter(List<Artifact> artifacts, List<String> groupArtifactIds) {
        ArrayList<Artifact> matches = new ArrayList<Artifact>();
        if (groupArtifactIds == null || artifacts == null) {
            return matches;
        }
        for (Artifact artifact : artifacts) {
            for (String groups : groupArtifactIds) {
                String[] groupArtifact = groups.split(":");
                if (groupArtifact.length != 2) {
                    throw new IllegalArgumentException("dependencyToScan argument should be in format 'groupid:artifactid': " + groups);
                }
                if (!artifact.getGroupId().matches(groupArtifact[0]) || !artifact.getArtifactId().matches(groupArtifact[1])) continue;
                matches.add(artifact);
            }
        }
        return matches;
    }
}

