/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.plugins.bootablejar.maven.common.FeaturePack;

public class FeaturePacksUtil {
    private static final String HEALTH = "health";
    private static final String MP_HEALTH = "microprofile-health";

    static ProvisioningSpecifics getSpecifics(List<FeaturePack> fps, ProvisioningManager pm) throws ProvisioningException, IOException {
        return new ProvisioningSpecifics(FeaturePacksUtil.getAllLayers(fps, pm));
    }

    private static Set<String> getAllLayers(List<FeaturePack> fps, ProvisioningManager pm) throws ProvisioningException, IOException {
        HashSet<String> allLayers = new HashSet<String>();
        for (FeaturePack fp : fps) {
            FeaturePackLocation fpl;
            if (fp.getNormalizedPath() != null) {
                fpl = pm.getLayoutFactory().addLocal(fp.getNormalizedPath(), false);
            } else if (fp.getGroupId() != null && fp.getArtifactId() != null) {
                String coords = fp.getMavenCoords();
                fpl = FeaturePackLocation.fromString((String)coords);
            } else {
                fpl = FeaturePackLocation.fromString((String)fp.getLocation());
            }
            ProvisioningConfig pConfig = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(FeaturePackConfig.builder((FeaturePackLocation)fpl).build())).build();
            ProvisioningLayout layout = pm.getLayoutFactory().newConfigLayout(pConfig);
            try {
                allLayers.addAll(FeaturePacksUtil.getAllLayers((ProvisioningLayout<FeaturePackLayout>)layout));
            }
            finally {
                if (layout == null) continue;
                layout.close();
            }
        }
        return allLayers;
    }

    private static Set<String> getAllLayers(ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        HashSet<String> layers = new HashSet<String>();
        for (FeaturePackLayout fp : pLayout.getOrderedFeaturePacks()) {
            for (ConfigId layer : fp.loadLayers()) {
                layers.add(layer.getName());
            }
        }
        return layers;
    }

    public static class ProvisioningSpecifics {
        private final boolean isMicroprofile;
        private final String healthLayer;

        ProvisioningSpecifics(Set<String> allLayers) {
            if (allLayers.contains(FeaturePacksUtil.MP_HEALTH)) {
                this.healthLayer = FeaturePacksUtil.MP_HEALTH;
                this.isMicroprofile = true;
            } else {
                this.healthLayer = allLayers.contains(FeaturePacksUtil.HEALTH) ? FeaturePacksUtil.HEALTH : null;
                this.isMicroprofile = false;
            }
        }

        ConfigId getDefaultConfig(boolean isCloud) {
            if (isCloud) {
                if (this.isMicroprofile) {
                    return new ConfigId("standalone", "standalone-microprofile-ha.xml");
                }
                return new ConfigId("standalone", "standalone-ha.xml");
            }
            if (this.isMicroprofile) {
                return new ConfigId("standalone", "standalone-microprofile.xml");
            }
            return new ConfigId("standalone", "standalone.xml");
        }

        String getHealthLayer() {
            return this.healthLayer;
        }
    }
}

