/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.File;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.common.DeploymentFailureException;
import org.wildfly.plugin.deployment.AbstractDeployment;
import org.wildfly.plugin.deployment.Deployment;

@Mojo(name="deploy-artifact", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public final class DeployArtifactMojo
extends AbstractDeployment {
    @Parameter
    private String groupId;
    @Parameter
    private String artifactId;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="true", property="deploy.force")
    private boolean force;
    private File file;

    @Override
    public void validate(ModelControllerClient client, boolean isDomain) throws DeploymentFailureException {
        super.validate(client, isDomain);
        if (this.artifactId == null) {
            throw new DeploymentFailureException("deploy-artifact must specify the artifactId");
        }
        if (this.groupId == null) {
            throw new DeploymentFailureException("deploy-artifact must specify the groupId");
        }
        Set dependencies = this.project.getDependencyArtifacts();
        Artifact artifact = null;
        for (Artifact a : dependencies) {
            if (!Objects.equals(a.getArtifactId(), this.artifactId) || !Objects.equals(a.getGroupId(), this.groupId) || !Objects.equals(a.getClassifier(), this.classifier)) continue;
            artifact = a;
            break;
        }
        if (artifact == null) {
            throw new DeploymentFailureException("Could not resolve artifact to deploy " + this.groupId + ":" + this.artifactId);
        }
        this.file = artifact.getFile();
    }

    @Override
    protected File file() {
        return this.file;
    }

    @Override
    public String goal() {
        return "deploy-artifact";
    }

    @Override
    public Deployment.Type getType() {
        return this.force ? Deployment.Type.FORCE_DEPLOY : Deployment.Type.DEPLOY;
    }
}

