/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.File;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.deployment.Deployment;
import org.wildfly.plugin.deployment.MatchPatternStrategy;

public abstract class DeploymentBuilder<T extends DeploymentBuilder<? super T>> {
    protected final ModelControllerClient client;
    private File content;
    private String name;
    private String runtimeName;
    private Deployment.Type type;
    private String matchPattern;
    private MatchPatternStrategy matchPatternStrategy;

    protected DeploymentBuilder(ModelControllerClient client) {
        if (client == null) {
            throw new IllegalArgumentException("The client must be set to communicate with the server.");
        }
        this.client = client;
    }

    public Deployment build() {
        this.validate();
        return this.doBuild();
    }

    protected File getContent() {
        return this.content;
    }

    public T setContent(File content) {
        this.content = content;
        return this.getThis();
    }

    protected String getName() {
        return this.name;
    }

    public T setName(String name) {
        this.name = name;
        return this.getThis();
    }

    protected String getRuntimeName() {
        return this.runtimeName;
    }

    public T setRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
        return this.getThis();
    }

    protected Deployment.Type getType() {
        return this.type;
    }

    public T setType(Deployment.Type type) {
        this.type = type;
        return this.getThis();
    }

    protected String getMatchPattern() {
        return this.matchPattern;
    }

    public T setMatchPattern(String matchPattern) {
        this.matchPattern = matchPattern;
        return this.getThis();
    }

    protected MatchPatternStrategy getMatchPatternStrategy() {
        return this.matchPatternStrategy;
    }

    public T setMatchPatternStrategy(MatchPatternStrategy matchPatternStrategy) {
        this.matchPatternStrategy = matchPatternStrategy;
        return this.getThis();
    }

    protected abstract T getThis();

    protected abstract Deployment doBuild();

    protected void validate() {
        if (this.type != Deployment.Type.UNDEPLOY && this.type != Deployment.Type.UNDEPLOY_IGNORE_MISSING && this.content == null) {
            throw new IllegalStateException("The content to be deployed must be set for for deployments and re-deployments.");
        }
    }
}

