/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.provision;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.logging.Log;

public class ExecUtil {
    private static final int PROCESS_CHECK_INTERVAL = 500;

    public static boolean exec(Log log, String command, String ... args) {
        return ExecUtil.exec(log, new File("."), command, args);
    }

    public static boolean execSilentWithTimeout(Duration timeout, String command, String ... args) {
        return ExecUtil.execWithTimeout(null, new File("."), timeout, command, args);
    }

    public static boolean exec(Log log, File directory, String command, String ... args) {
        try {
            Process process = ExecUtil.startProcess(directory, command, args);
            new HandleOutput(process.getInputStream(), log).run();
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static boolean execWithTimeout(Log log, File directory, Duration timeout, String command, String ... args) {
        try {
            Process process = ExecUtil.startProcess(directory, command, args);
            Thread t = new Thread(new HandleOutput(process.getInputStream(), log));
            t.setName("Process stdout");
            t.setDaemon(true);
            t.start();
            process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
            ExecUtil.destroyProcess(process);
            return process.exitValue() == 0;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static Process startProcess(File directory, String command, String ... args) {
        try {
            String[] cmd = new String[args.length + 1];
            cmd[0] = command;
            if (args.length > 0) {
                System.arraycopy(args, 0, cmd, 1, args.length);
            }
            return new ProcessBuilder(new String[0]).directory(directory).command(cmd).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while executing command.", e);
        }
    }

    public static void destroyProcess(Process process) {
        process.destroy();
        int i = 0;
        while (process.isAlive() && i++ < 10) {
            try {
                process.waitFor(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        if (process.isAlive()) {
            process.destroyForcibly();
        }
    }

    public static String resolveImageBinary() {
        try {
            if (ExecUtil.execSilentWithTimeout(Duration.ofSeconds(3L), "docker", "-v")) {
                return "docker";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (ExecUtil.execSilentWithTimeout(Duration.ofSeconds(3L), "podman", "-v")) {
                return "podman";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static class HandleOutput
    implements Runnable {
        private final InputStream is;
        private Log log;

        HandleOutput(InputStream is, Log log) {
            this.is = is;
            this.log = log;
        }

        @Override
        public void run() {
            try (InputStreamReader isr = new InputStreamReader(this.is);
                 BufferedReader reader = new BufferedReader(isr);){
                String line = reader.readLine();
                while (line != null) {
                    if (this.log != null) {
                        this.log.info((CharSequence)line);
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                this.log.error((CharSequence)"Failed to handle output", (Throwable)e);
            }
        }
    }
}

