/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.dev;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.plugin.dev.WatchContext;
import org.wildfly.plugin.dev.WatchHandler;

class WebAppResourceHandler
implements WatchHandler {
    private static final Set<String> NO_DEPLOYMENT_WEB_FILE_EXTENSIONS = Set.of(".xhtml", ".html", ".jsp", ".js", ".css");
    private final Set<String> ignoredFileExtensions;

    WebAppResourceHandler(Collection<String> ignoredFileExtensions) {
        this.ignoredFileExtensions = ignoredFileExtensions.stream().map(value -> value.charAt(0) == '.' ? value : "." + value).collect(Collectors.toCollection(HashSet::new));
        this.ignoredFileExtensions.addAll(NO_DEPLOYMENT_WEB_FILE_EXTENSIONS);
    }

    @Override
    public WatchHandler.Result handle(WatchContext context, WatchEvent<Path> event, Path file) throws IOException {
        String fileName = file.getFileName().toString();
        int dot = fileName.lastIndexOf(46);
        final boolean requiresRedeploy = dot <= 0 || !this.ignoredFileExtensions.contains(fileName.substring(dot).toLowerCase(Locale.ROOT));
        return new WatchHandler.Result(){

            @Override
            public boolean requiresRepackage() {
                return true;
            }

            @Override
            public boolean requiresRedeploy() {
                return requiresRedeploy;
            }
        };
    }
}

