/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.wildfly.common.Assert;
import org.wildfly.plugin.core.Assertions;
import org.wildfly.plugin.core.DeploymentContent;
import org.wildfly.plugin.core.DeploymentDescription;

public class Deployment
implements DeploymentDescription,
Comparable<Deployment> {
    private final DeploymentContent content;
    private final Set<String> serverGroups;
    private String name;
    private String runtimeName;
    private boolean enabled = true;

    private Deployment(DeploymentContent content, String name) {
        this.content = content;
        this.name = Assertions.requiresNotNullOrNotEmptyParameter("name", name == null ? this.content.resolvedName() : name);
        this.serverGroups = new LinkedHashSet<String>();
    }

    public static Deployment of(File content) {
        DeploymentContent deploymentContent = DeploymentContent.of(((File)Assert.checkNotNullParam((String)"content", (Object)content)).toPath());
        return new Deployment(deploymentContent, null);
    }

    public static Deployment of(Path content) {
        DeploymentContent deploymentContent = DeploymentContent.of((Path)Assert.checkNotNullParam((String)"content", (Object)content));
        return new Deployment(deploymentContent, null);
    }

    public static Deployment of(InputStream content, String name) {
        DeploymentContent deploymentContent = DeploymentContent.of((InputStream)Assert.checkNotNullParam((String)"content", (Object)content));
        return new Deployment(deploymentContent, Assertions.requiresNotNullOrNotEmptyParameter("name", name));
    }

    public static Deployment of(URL url) {
        DeploymentContent deploymentContent = DeploymentContent.of((URL)Assert.checkNotNullParam((String)"url", (Object)url));
        return new Deployment(deploymentContent, null);
    }

    public static Deployment local(Path content) {
        DeploymentContent deploymentContent = DeploymentContent.local((Path)Assert.checkNotNullParam((String)"content", (Object)content));
        return new Deployment(deploymentContent, null);
    }

    public Deployment addServerGroup(String serverGroup) {
        this.serverGroups.add(serverGroup);
        return this;
    }

    public Deployment addServerGroups(String ... serverGroups) {
        return this.addServerGroups(Arrays.asList(serverGroups));
    }

    public Deployment addServerGroups(Collection<String> serverGroups) {
        this.serverGroups.addAll(serverGroups);
        return this;
    }

    @Override
    public Set<String> getServerGroups() {
        return Collections.unmodifiableSet(this.serverGroups);
    }

    public Deployment setServerGroups(String ... serverGroups) {
        return this.setServerGroups(Arrays.asList(serverGroups));
    }

    public Deployment setServerGroups(Collection<String> serverGroups) {
        this.serverGroups.clear();
        this.serverGroups.addAll(serverGroups);
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Deployment setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Deployment setName(String name) {
        if (name == null) {
            this.name = this.content.resolvedName();
            if (this.name == null) {
                throw new IllegalArgumentException("The name parameter is required and could not be resolved from the content: " + this.content);
            }
        } else {
            this.name = name;
        }
        return this;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public Deployment setRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
        return this;
    }

    @Override
    public int compareTo(Deployment o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(Deployment.class.getSimpleName());
        result.append('(');
        result.append("name=").append(this.name);
        if (this.runtimeName != null) {
            result.append(", runtimeName=").append(this.runtimeName);
        }
        if (!this.serverGroups.isEmpty()) {
            result.append(", serverGroups=").append(this.serverGroups);
        }
        result.append(", content=").append(this.content);
        return result.append(')').toString();
    }

    DeploymentContent getContent() {
        return this.content;
    }
}

