/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import org.apache.maven.plugin.logging.Log;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;

@Deprecated(forRemoval=true)
public class PluginProgressTracker<T>
implements ProgressCallback<T> {
    private static final String DELAYED_EXECUTION_MSG = "Delayed generation, waiting...";
    private final Log log;
    private final String msgStart;
    private long lastTime;
    private final boolean delayed;

    private PluginProgressTracker(Log log, String msgStart, boolean delayed) {
        this.log = log;
        this.msgStart = msgStart;
        this.delayed = delayed;
    }

    public void starting(ProgressTracker<T> tracker) {
        this.log.info((CharSequence)this.msgStart);
        this.lastTime = System.currentTimeMillis();
    }

    public void processing(ProgressTracker<T> tracker) {
        if (this.delayed && tracker.getItem() == null) {
            this.log.info((CharSequence)DELAYED_EXECUTION_MSG);
            return;
        }
        if (System.currentTimeMillis() - this.lastTime > 5000L) {
            if (tracker.getTotalVolume() > 0L) {
                this.log.info((CharSequence)String.format("%s of %s (%s%%)", tracker.getProcessedVolume(), tracker.getTotalVolume(), (double)Math.round(tracker.getProgress() * 10.0) / 10.0));
            } else {
                this.log.info((CharSequence)"In progress...");
            }
            this.lastTime = System.currentTimeMillis();
        }
    }

    public void processed(ProgressTracker<T> tracker) {
    }

    public void pulse(ProgressTracker<T> tracker) {
    }

    public void complete(ProgressTracker<T> tracker) {
    }

    public static void initTrackers(ProvisioningManager pm, Log log) {
        pm.getLayoutFactory().setProgressCallback("PACKAGES", new PluginProgressTracker(log, "Installing packages", false));
        pm.getLayoutFactory().setProgressCallback("CONFIGS", new PluginProgressTracker(log, "Generating configurations", true));
        pm.getLayoutFactory().setProgressCallback("LAYOUT_BUILD", new PluginProgressTracker(log, "Resolving feature-packs", false));
        pm.getLayoutFactory().setProgressCallback("JBMODULES", new PluginProgressTracker(log, "Resolving artifacts", false));
        pm.getLayoutFactory().setProgressCallback("JBEXTRACONFIGS", new PluginProgressTracker(log, "Generating extra configurations", true));
    }
}

