/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.common;

import java.security.Provider;
import java.security.Security;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.impl.ServerMechanismFactoryImpl;
import org.wildfly.security.http.util.FilterServerMechanismFactory;
import org.wildfly.security.http.util.PropertiesServerMechanismFactory;

public abstract class AbstractHttpServerMechanismTest {
    private static final Provider ELYTRON_PROVIDER = new WildFlyElytronProvider();
    private SecurityDomain securityDomain;

    @BeforeClass
    public static void installProvider() {
        Security.addProvider(ELYTRON_PROVIDER);
    }

    @AfterClass
    public static void removeProvider() {
        Security.removeProvider(ELYTRON_PROVIDER.getName());
    }

    protected void assertSuccessfulResponse(HttpResponse result, String expectedUserName) {
        Header[] values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        values = result.getHeaders("UndertowUser");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)expectedUserName, (Object)values[0].getValue());
        values = result.getHeaders("ElytronUser");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)expectedUserName, (Object)values[0].getValue());
    }

    protected void assertSuccessfulUnconstraintResponse(HttpResponse result, String expectedUserName) {
        Header[] values = result.getHeaders("ProcessedBy");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"ResponseHandler", (Object)values[0].getValue());
        if (expectedUserName != null) {
            values = result.getHeaders("UndertowUser");
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)expectedUserName, (Object)values[0].getValue());
            values = result.getHeaders("ElytronUser");
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)expectedUserName, (Object)values[0].getValue());
        } else {
            values = result.getHeaders("UndertowUser");
            Assert.assertEquals((long)0L, (long)values.length);
            values = result.getHeaders("ElytronUser");
            Assert.assertEquals((long)1L, (long)values.length);
            Assert.assertEquals((Object)"anonymous", (Object)values[0].getValue());
        }
    }

    protected void assertLoginPage(HttpResponse response) throws Exception {
        Assert.assertTrue((boolean)EntityUtils.toString((HttpEntity)response.getEntity()).contains("Login Page"));
    }

    protected HttpServerAuthenticationMechanismFactory getHttpServerAuthenticationMechanismFactory(Map<String, ?> properties) {
        return new PropertiesServerMechanismFactory((HttpServerAuthenticationMechanismFactory)new FilterServerMechanismFactory((HttpServerAuthenticationMechanismFactory)new ServerMechanismFactoryImpl(), true, new String[]{this.getMechanismName()}), properties);
    }

    protected abstract String getMechanismName();

    protected SecurityDomain getSecurityDomain() throws Exception {
        if (this.securityDomain == null) {
            this.securityDomain = this.doCreateSecurityDomain();
        }
        return this.securityDomain;
    }

    protected abstract SecurityDomain doCreateSecurityDomain() throws Exception;
}

