/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.security.Principal;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.x500.ElytronMessages;
import org.wildfly.security.x500.util.X500PrincipalUtil;

@Deprecated
public final class X500AttributePrincipalDecoder
implements PrincipalDecoder {
    private static final String[] NO_REQUIRED_OIDS = new String[0];
    private final String oid;
    private final String joiner;
    private final int startSegment;
    private final int maximumSegments;
    private final boolean reverse;
    private final String[] requiredOids;
    private final boolean convert;

    public X500AttributePrincipalDecoder(String oid) {
        this(oid, false);
    }

    public X500AttributePrincipalDecoder(String oid, boolean reverse) {
        this(oid, ".", 0, Integer.MAX_VALUE, reverse);
    }

    public X500AttributePrincipalDecoder(String oid, int maximumSegments) {
        this(oid, maximumSegments, false);
    }

    public X500AttributePrincipalDecoder(String oid, int maximumSegments, boolean reverse) {
        this(oid, ".", 0, maximumSegments, reverse);
    }

    public X500AttributePrincipalDecoder(String oid, int startSegment, int maximumSegments) {
        this(oid, startSegment, maximumSegments, false);
    }

    public X500AttributePrincipalDecoder(String oid, int startSegment, int maximumSegments, boolean reverse) {
        this(oid, ".", startSegment, maximumSegments, reverse);
    }

    public X500AttributePrincipalDecoder(String oid, String joiner) {
        this(oid, joiner, false);
    }

    public X500AttributePrincipalDecoder(String oid, String joiner, boolean reverse) {
        this(oid, joiner, 0, Integer.MAX_VALUE, reverse);
    }

    public X500AttributePrincipalDecoder(String oid, String joiner, int maximumSegments) {
        this(oid, joiner, 0, maximumSegments, false);
    }

    public X500AttributePrincipalDecoder(String oid, String joiner, int startSegment, int maximumSegments, boolean reverse) {
        this(oid, joiner, startSegment, maximumSegments, reverse, false, NO_REQUIRED_OIDS);
    }

    public X500AttributePrincipalDecoder(String oid, String joiner, int startSegment, int maximumSegments, boolean reverse, boolean convert, String ... requiredOids) {
        this.oid = oid;
        this.joiner = joiner;
        this.startSegment = startSegment;
        this.maximumSegments = maximumSegments;
        this.reverse = reverse;
        this.convert = convert;
        this.requiredOids = requiredOids;
    }

    public String getName(Principal principal) {
        X500Principal x500Principal = X500PrincipalUtil.asX500Principal((Principal)principal, (boolean)this.convert);
        if (x500Principal == null) {
            return null;
        }
        if (this.requiredOids != null && this.requiredOids.length != 0 && !X500PrincipalUtil.containsAllAttributes((X500Principal)x500Principal, (String[])this.requiredOids)) {
            ElytronMessages.log.tracef("X500 principal [%s] was not decoded - does not contain required oids", x500Principal);
            return null;
        }
        CharSequence[] values = X500PrincipalUtil.getAttributeValues((X500Principal)x500Principal, (String)this.oid, (boolean)this.reverse);
        if (values.length == 0) {
            ElytronMessages.log.tracef("X500 principal [%s] was not decoded - no values of attribute [%s]", x500Principal, this.oid);
            return null;
        }
        String name = Arrays.stream(values).skip(this.startSegment).limit(this.maximumSegments).collect(Collectors.joining(this.joiner));
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("X500 principal [%s] decoded as name [%s] (attribute values: [%s])", x500Principal, name, String.join((CharSequence)", ", values));
        }
        return name;
    }
}

