/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;

public class SetVariableHandler
extends CommandHandlerWithHelp {
    public SetVariableHandler() {
        super("set");
        new ArgumentWithValue((CommandHandlerWithArguments)this, OperationRequestCompleter.ARG_VALUE_COMPLETER, 0, "--variable");
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine parsedArgs = ctx.getParsedCommandLine();
        List<String> vars = parsedArgs.getOtherProperties();
        if (vars.isEmpty()) {
            Collection<String> defined = ctx.getVariables();
            if (defined.isEmpty()) {
                return;
            }
            ArrayList<String> pairs = new ArrayList<String>(defined.size());
            for (String var : defined) {
                pairs.add(var + '=' + ctx.getVariable(var));
            }
            Collections.sort(pairs);
            for (String pair : pairs) {
                ctx.printLine(pair);
            }
            return;
        }
        for (String arg : vars) {
            if (arg.charAt(0) == '$' && (arg = arg.substring(1)).isEmpty()) {
                throw new CommandFormatException("Variable name is missing after '$'");
            }
            int equals = arg.indexOf(61);
            if (equals < 1) {
                throw new CommandFormatException("'=' is missing for variable '" + arg + "'");
            }
            String name = arg.substring(0, equals);
            if (name.isEmpty()) {
                throw new CommandFormatException("The name is missing in '" + arg + "'");
            }
            if (equals == arg.length() - 1) {
                ctx.setVariable(name, null);
                continue;
            }
            ctx.setVariable(name, arg.substring(equals + 1));
        }
    }

    @Override
    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        Set<String> propertyNames = args.getPropertyNames();
        if (!propertyNames.isEmpty()) {
            Collection<String> names;
            if (this.helpArg.isPresent(args)) {
                if (propertyNames.size() == 1) {
                    return;
                }
                names = new ArrayList<String>(propertyNames);
                names.remove(this.helpArg.getFullName());
                names.remove(this.helpArg.getShortName());
            } else {
                names = propertyNames;
            }
            throw new CommandFormatException("Unrecognized argument names: " + names);
        }
    }
}

