/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.ArrayDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.wildfly.common.Assert;

public class LimitedExecutor
implements Executor {
    private final Executor executor;
    private final Thread.UncaughtExceptionHandler handler;
    private final int concurrencyLimit;
    private final Runner runner;

    public LimitedExecutor(Executor executor, Thread.UncaughtExceptionHandler handler, int concurrencyLimit) {
        this.executor = executor;
        this.handler = handler;
        this.concurrencyLimit = concurrencyLimit;
        this.runner = new Runner();
    }

    public LimitedExecutor(Executor executor, int concurrencyLimit) {
        this(executor, null, concurrencyLimit);
    }

    @Override
    public void execute(Runnable command) throws RejectedExecutionException {
        Assert.checkNotNullParam("command", command);
        this.runner.add(command);
    }

    public String toString() {
        return String.format("Limited executor (%d tasks) over %s", this.concurrencyLimit, this.executor);
    }

    class Runner
    extends ArrayDeque<Runnable>
    implements Runnable {
        private int runCount;

        Runner() {
        }

        @Override
        public synchronized boolean add(Runnable runnable) {
            int runCount = this.runCount;
            if (runCount < LimitedExecutor.this.concurrencyLimit) {
                LimitedExecutor.this.executor.execute(this);
                this.runCount = runCount + 1;
            }
            return super.add(runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Runnable task;
                Runner runner = this;
                synchronized (runner) {
                    task = (Runnable)this.poll();
                    if (task == null) {
                        --this.runCount;
                        return;
                    }
                }
                try {
                    task.run();
                    continue;
                }
                catch (Throwable t) {
                    Thread.UncaughtExceptionHandler handler = LimitedExecutor.this.handler;
                    if (handler == null) continue;
                    try {
                        handler.uncaughtException(Thread.currentThread(), t);
                    }
                    catch (Throwable throwable) {
                    }
                    continue;
                }
                break;
            }
        }

        @Override
        public String toString() {
            return String.format("Task runner for %s", LimitedExecutor.this);
        }
    }
}

