/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

public enum CompletableFutures {
    INSTANCE;

    private static final CompletableFuture<?> NULL;
    private static final Consumer<?> VOID_CONSUMER;

    public static <T> T join(CompletionStage<T> cs) {
        return CompletableFutures.join(cs.toCompletableFuture());
    }

    public static <T> T join(CompletableFuture<T> cf) {
        try {
            return cf.join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static <T> CompletableFuture<T> completedNull() {
        return NULL;
    }

    public static <T> Consumer<T> voidConsumer() {
        return VOID_CONSUMER;
    }

    static {
        NULL = CompletableFuture.completedFuture(null);
        VOID_CONSUMER = o -> {};
    }
}

