/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.naming;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.controller.CommonRequirement;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;

public class BinderServiceBuilder<T>
implements CapabilityServiceBuilder<ManagedReferenceFactory> {
    private final ContextNames.BindInfo binding;
    private final ServiceName targetServiceName;
    private final Class<T> targetClass;
    private final List<ContextNames.BindInfo> aliases = new LinkedList<ContextNames.BindInfo>();
    private volatile boolean enabled = true;

    public BinderServiceBuilder(ContextNames.BindInfo binding, ServiceName targetServiceName, Class<T> targetClass) {
        this.binding = binding;
        this.targetServiceName = targetServiceName;
        this.targetClass = targetClass;
    }

    public BinderServiceBuilder<T> alias(ContextNames.BindInfo alias) {
        this.aliases.add(alias);
        return this;
    }

    public ServiceName getServiceName() {
        return this.binding.getBinderServiceName();
    }

    @Override
    public Builder<ManagedReferenceFactory> configure(OperationContext context) {
        this.enabled = context.hasOptionalCapability(CommonRequirement.NAMING_STORE.getName(), null, null);
        return this;
    }

    public ServiceBuilder<ManagedReferenceFactory> build(ServiceTarget target) {
        if (!this.enabled) {
            ImmediateValue value = new ImmediateValue(null);
            return target.addService(this.getServiceName(), (Service)new ValueService((Value)value)).setInitialMode(ServiceController.Mode.NEVER);
        }
        String name = this.binding.getBindName();
        BinderService binder = new BinderService(name);
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{name})}).addDependency(this.targetServiceName, this.targetClass, (Injector)new ManagedReferenceInjector((Injector)binder.getManagedObjectInjector())).addDependency(this.binding.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector());
        for (ContextNames.BindInfo alias : this.aliases) {
            builder.addAliases(new ServiceName[]{alias.getBinderServiceName(), ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{alias.getBindName()})});
        }
        return builder.setInitialMode(ServiceController.Mode.PASSIVE);
    }
}

