/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.annotations.repository.jandex;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.connector.logging.ConnectorLogger;

public class AnnotationImpl
implements org.jboss.jca.common.spi.annotations.repository.Annotation {
    private final String className;
    private final ClassLoader cl;
    private final List<String> parameterTypes;
    private final String memberName;
    private final boolean onMethod;
    private final boolean onField;
    private final Class<? extends Annotation> annotationClass;

    public AnnotationImpl(String className, ClassLoader cl, List<String> parameterTypes, String memberName, boolean onMethod, boolean onField, Class<?> annotationClass) {
        this.className = className;
        this.cl = cl;
        if (parameterTypes != null) {
            this.parameterTypes = new ArrayList<String>(parameterTypes.size());
            this.parameterTypes.addAll(parameterTypes);
        } else {
            this.parameterTypes = new ArrayList<String>(0);
        }
        this.memberName = memberName;
        this.onMethod = onMethod;
        this.onField = onField;
        if (!annotationClass.isAnnotation()) {
            throw ConnectorLogger.ROOT_LOGGER.notAnAnnotation(annotationClass);
        }
        this.annotationClass = annotationClass;
    }

    public final String getClassName() {
        return this.className;
    }

    public final Object getAnnotation() {
        block11: {
            try {
                if (this.isOnField()) {
                    Class<?> clazz = this.cl.loadClass(this.className);
                    while (!clazz.equals(Object.class)) {
                        try {
                            Field field = clazz.getDeclaredField(this.memberName);
                            return field.getAnnotation(this.annotationClass);
                        }
                        catch (Throwable t) {
                            clazz = clazz.getSuperclass();
                        }
                    }
                    break block11;
                }
                if (this.isOnMethod()) {
                    Class<?> clazz = this.cl.loadClass(this.className);
                    Class[] params = new Class[this.parameterTypes.size()];
                    int i = 0;
                    for (String paramClazz : this.parameterTypes) {
                        params[i] = this.cl.loadClass(paramClazz);
                        ++i;
                    }
                    while (!clazz.equals(Object.class)) {
                        try {
                            Method method = clazz.getDeclaredMethod(this.memberName, params);
                            return method.getAnnotation(this.annotationClass);
                        }
                        catch (Throwable t) {
                            clazz = clazz.getSuperclass();
                        }
                    }
                    break block11;
                }
                Class<?> clazz = this.cl.loadClass(this.className);
                return clazz.getAnnotation(this.annotationClass);
            }
            catch (Exception e) {
                ConnectorLogger.ROOT_LOGGER.debug(e.getMessage(), e);
            }
        }
        return null;
    }

    public final List<String> getParameterTypes() {
        return Collections.unmodifiableList(this.parameterTypes);
    }

    public final String getMemberName() {
        return this.memberName;
    }

    public final boolean isOnMethod() {
        return this.onMethod;
    }

    public final boolean isOnField() {
        return this.onField;
    }
}

