/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyContextHandler;
import jakarta.servlet.http.HttpServletRequest;
import java.security.PrivilegedAction;
import org.wildfly.security.authz.jacc.HttpServletRequestContext;
import org.wildfly.security.authz.jacc.SecurityActions;

class RequestPolicyContextHandler
implements PolicyContextHandler {
    private static final String KEY = "jakarta.servlet.http.HttpServletRequest";
    private final PrivilegedAction<HttpServletRequest> getRequestAction;

    RequestPolicyContextHandler(final HttpServletRequestContext requestContext) {
        this.getRequestAction = new PrivilegedAction<HttpServletRequest>(){

            @Override
            public HttpServletRequest run() {
                return requestContext.getCurrent();
            }
        };
    }

    public boolean supports(String key) throws PolicyContextException {
        return KEY.equalsIgnoreCase(key);
    }

    public String[] getKeys() throws PolicyContextException {
        return new String[]{KEY};
    }

    public Object getContext(String key, Object data) throws PolicyContextException {
        if (!this.supports(key)) {
            return null;
        }
        return SecurityActions.doPrivileged(this.getRequestAction);
    }
}

