/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.Iterator;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.ParsedOperationRequestHeader;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.ParsedRolloutPlanHeader;
import org.jboss.as.cli.operation.impl.SingleRolloutPlanGroup;

public class RolloutPlanCompleter
implements CommandLineCompleter {
    public static final RolloutPlanCompleter INSTANCE = new RolloutPlanCompleter();
    private static final DefaultOperationRequestAddress address = new DefaultOperationRequestAddress();
    private final DefaultCallbackHandler parsedOp = new DefaultCallbackHandler();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        SingleRolloutPlanGroup lastGroup;
        boolean containsAllGroups;
        List<String> serverGroups;
        block46: {
            boolean containsAll;
            block45: {
                String propName;
                block49: {
                    block48: {
                        block47: {
                            if (!ctx.isDomainMode()) {
                                return -1;
                            }
                            if (buffer.isEmpty()) {
                                candidates.add("{rollout");
                                return 0;
                            }
                            try {
                                this.parsedOp.parseOperation(null, buffer, ctx);
                            }
                            catch (CommandFormatException e) {
                                return -1;
                            }
                            if (this.parsedOp.isRequestComplete()) {
                                return -1;
                            }
                            if (this.parsedOp.endsOnHeaderListStart() || this.parsedOp.endsOnHeaderSeparator()) {
                                candidates.add("rollout");
                                return this.parsedOp.getLastSeparatorIndex() + 1;
                            }
                            if (this.parsedOp.getLastHeader() == null) {
                                if (!ctx.getParsedCommandLine().getOriginalLine().endsWith(" ")) {
                                    if (!ctx.getParsedCommandLine().getOriginalLine().endsWith("rollout")) return buffer.length();
                                    candidates.add(" ");
                                    return buffer.length();
                                }
                                String originalLine = ctx.getParsedCommandLine().getOriginalLine();
                                int bufferIndex = originalLine.lastIndexOf(buffer);
                                if (bufferIndex == -1) {
                                    return -1;
                                }
                                candidates.add("name=");
                                candidates.addAll(Util.getServerGroups(ctx.getModelControllerClient()));
                                return originalLine.length() - bufferIndex;
                            }
                            ParsedOperationRequestHeader lastHeader = this.parsedOp.getLastHeader();
                            if (!(lastHeader instanceof ParsedRolloutPlanHeader)) {
                                throw new IllegalStateException("Expected " + ParsedRolloutPlanHeader.class + " but got " + lastHeader.getName() + " of " + lastHeader);
                            }
                            ParsedRolloutPlanHeader rollout = (ParsedRolloutPlanHeader)lastHeader;
                            if (rollout.endsOnPlanIdValueSeparator()) {
                                candidates.addAll(Util.getNodeNames(ctx.getModelControllerClient(), address, "rollout-plan"));
                                return rollout.getLastSeparatorIndex() + 1;
                            }
                            String planRef = rollout.getPlanRef();
                            if (planRef != null) {
                                List<String> nodeNames = Util.getNodeNames(ctx.getModelControllerClient(), address, "rollout-plan");
                                Iterator<String> iterator = nodeNames.iterator();
                                while (iterator.hasNext()) {
                                    String name = iterator.next();
                                    if (!name.startsWith(planRef)) continue;
                                    candidates.add(name);
                                }
                                return rollout.getLastChunkIndex();
                            }
                            if (rollout.hasProperties()) {
                                String lastName = rollout.getLastPropertyName();
                                if (!"rollback-across-groups".equals(lastName)) {
                                    if (!"rollback-across-groups".startsWith(lastName)) return rollout.getLastChunkIndex();
                                    candidates.add("rollback-across-groups");
                                    return rollout.getLastChunkIndex();
                                }
                                if (rollout.getLastPropertyValue() != null) {
                                    return -1;
                                }
                                candidates.add("}");
                                candidates.add(";");
                                return rollout.getLastChunkIndex() + lastName.length();
                            }
                            serverGroups = Util.getServerGroups(ctx.getModelControllerClient());
                            containsAllGroups = true;
                            for (String group : serverGroups) {
                                if (rollout.containsGroup(group)) continue;
                                containsAllGroups = false;
                                break;
                            }
                            if (rollout.endsOnGroupSeparator()) {
                                if (containsAllGroups) {
                                    return -1;
                                }
                                Iterator<String> name = serverGroups.iterator();
                                while (name.hasNext()) {
                                    String group;
                                    group = name.next();
                                    if (rollout.containsGroup(group)) continue;
                                    candidates.add(group);
                                }
                                return buffer.length();
                            }
                            lastGroup = rollout.getLastGroup();
                            if (lastGroup == null) {
                                return -1;
                            }
                            if (lastGroup.endsOnPropertyListEnd()) {
                                if (!containsAllGroups) {
                                    candidates.add("^");
                                    candidates.add(",");
                                    return buffer.length();
                                }
                                if (Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
                                    candidates.add("rollback-across-groups");
                                    return buffer.length();
                                }
                                candidates.add(" ");
                                return buffer.length();
                            }
                            if (lastGroup.endsOnPropertyListStart()) {
                                candidates.add("max-failed-servers");
                                candidates.add("max-failure-percentage");
                                candidates.add("rolling-to-servers");
                                candidates.add("!");
                                return buffer.length();
                            }
                            if (lastGroup.endsOnNotOperator()) {
                                candidates.add("rolling-to-servers");
                                return buffer.length();
                            }
                            if (!lastGroup.hasProperties()) break block46;
                            containsAll = lastGroup.hasProperty("max-failed-servers") && lastGroup.hasProperty("max-failure-percentage") && lastGroup.hasProperty("rolling-to-servers");
                            String propValue = lastGroup.getLastPropertyValue();
                            if (propValue == null) break block47;
                            if ("true".startsWith(propValue)) {
                                candidates.add("true");
                                break block45;
                            } else if ("false".startsWith(propValue)) {
                                candidates.add("false");
                                break block45;
                            } else {
                                candidates.add(containsAll ? ")" : ",");
                                return buffer.length();
                            }
                        }
                        if (lastGroup.endsOnPropertyValueSeparator()) {
                            if (!"rolling-to-servers".equals(lastGroup.getLastPropertyName())) return buffer.length();
                            candidates.add("false");
                            candidates.add(containsAll ? ")" : ",");
                            return buffer.length();
                        }
                        if (lastGroup.endsOnPropertySeparator()) {
                            if (!lastGroup.hasProperty("max-failed-servers")) {
                                candidates.add("max-failed-servers");
                            }
                            if (!lastGroup.hasProperty("max-failure-percentage")) {
                                candidates.add("max-failure-percentage");
                            }
                            if (lastGroup.hasProperty("rolling-to-servers")) return lastGroup.getLastSeparatorIndex() + 1;
                            candidates.add("rolling-to-servers");
                            candidates.add("!");
                            return lastGroup.getLastSeparatorIndex() + 1;
                        }
                        propName = lastGroup.getLastPropertyName();
                        if ("max-failed-servers".startsWith(propName)) {
                            candidates.add("max-failed-servers=");
                        }
                        if (!"max-failure-percentage".startsWith(propName)) break block48;
                        candidates.add("max-failure-percentage=");
                        break block45;
                    }
                    if (!"rolling-to-servers".equals(propName)) break block49;
                    if (lastGroup.isLastPropertyNegated() && !containsAll) {
                        candidates.add("rolling-to-servers,");
                        break block45;
                    } else {
                        candidates.add("=false");
                        if (!containsAll) {
                            candidates.add(",");
                            break block45;
                        } else {
                            candidates.add(")");
                        }
                    }
                    break block45;
                }
                if ("rolling-to-servers".startsWith(propName)) {
                    candidates.add("rolling-to-servers");
                }
            }
            if (!candidates.isEmpty()) return lastGroup.getLastChunkIndex();
            if (!containsAll) return lastGroup.getLastChunkIndex();
            candidates.add(")");
            return lastGroup.getLastChunkIndex();
        }
        if (Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
            candidates.add("rollback-across-groups");
            return buffer.length();
        }
        int result = lastGroup.getLastChunkIndex();
        String groupName = lastGroup.getGroupName();
        boolean isLastGroup = false;
        for (String group : serverGroups) {
            if (group.equals(groupName)) {
                isLastGroup = true;
            }
            if (isLastGroup || !group.startsWith(groupName)) continue;
            candidates.add(group);
        }
        if ("name".startsWith(groupName)) {
            candidates.add("name=");
            return result;
        }
        if (!candidates.isEmpty()) return result;
        if (!isLastGroup) return result;
        candidates.add("(");
        if (containsAllGroups) {
            candidates.add("rollback-across-groups");
            return result;
        }
        candidates.add(",");
        candidates.add("^");
        return result;
    }

    static {
        address.toNode("management-client-content", "rollout-plans");
    }
}

