/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.util.Collection;
import org.glassfish.enterprise.concurrent.AbstractManagedThread;
import org.jboss.as.ee.concurrent.ManagedThreadFactoryImpl;
import org.jboss.as.ee.logging.EeLogger;

public interface ManagedExecutorWithHungThreads {
    public String getName();

    default public void terminateHungTasks() {
        String executorName = this.getClass().getSimpleName() + ":" + this.getName();
        EeLogger.ROOT_LOGGER.debugf("Cancelling %s hung tasks...", executorName);
        Collection<AbstractManagedThread> hungThreads = this.getHungThreads();
        if (hungThreads != null) {
            for (AbstractManagedThread t : hungThreads) {
                String taskIdentityName = t.getTaskIdentityName();
                try {
                    if (!(t instanceof ManagedThreadFactoryImpl.ManagedThread)) continue;
                    if (((ManagedThreadFactoryImpl.ManagedThread)t).cancelTask()) {
                        EeLogger.ROOT_LOGGER.hungTaskCancelled(executorName, taskIdentityName);
                        continue;
                    }
                    EeLogger.ROOT_LOGGER.hungTaskNotCancelled(executorName, taskIdentityName);
                }
                catch (Throwable throwable) {
                    EeLogger.ROOT_LOGGER.huntTaskTerminationFailure(throwable, executorName, taskIdentityName);
                }
            }
        }
    }

    public Collection<AbstractManagedThread> getHungThreads();
}

