/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.facet.impl;

import java.util.Collection;
import java.util.function.ToLongFunction;
import org.apache.lucene.facet.range.LongRange;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

public class FacetCountsUtils {
    private FacetCountsUtils() {
    }

    public static <T extends Number> LongRange[] createLongRangesForIntegralValues(Collection<? extends Range<? extends T>> ranges) {
        return FacetCountsUtils.createLongRanges(ranges, Number::longValue, Long.MIN_VALUE, Long.MAX_VALUE, false);
    }

    public static <T> LongRange[] createLongRangesForFloatingPointValues(Collection<? extends Range<? extends T>> ranges, ToLongFunction<T> encoder, T negativeInfinity, T positiveInfinity) {
        return FacetCountsUtils.createLongRanges(ranges, encoder, negativeInfinity, positiveInfinity, true);
    }

    private static <T> LongRange[] createLongRanges(Collection<? extends Range<? extends T>> ranges, ToLongFunction<T> encoder, T lowestPossibleValue, T highestPossibleValue, boolean extremaAreInfinity) {
        LongRange[] longRanges = new LongRange[ranges.size()];
        int i = 0;
        for (Range<T> range : ranges) {
            Object lowerBoundValue = range.lowerBoundValue().orElse(null);
            Object upperBoundValue = range.upperBoundValue().orElse(null);
            longRanges[i] = new LongRange(String.valueOf(i), encoder.applyAsLong(lowerBoundValue == null ? lowestPossibleValue : lowerBoundValue), RangeBoundInclusion.INCLUDED.equals((Object)range.lowerBoundInclusion()) || !extremaAreInfinity && lowerBoundValue == null, encoder.applyAsLong(upperBoundValue == null ? highestPossibleValue : upperBoundValue), RangeBoundInclusion.INCLUDED.equals((Object)range.upperBoundInclusion()) || !extremaAreInfinity && upperBoundValue == null);
            ++i;
        }
        return longRanges;
    }
}

