/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.extraction.impl.ExtractionRequirements;
import org.hibernate.search.backend.lucene.search.highlighter.impl.LuceneAbstractSearchHighlighter;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ProjectionRequestContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ExtractionRequirements.Builder extractionRequirementsBuilder;
    private final String absoluteCurrentNestedFieldPath;
    private final String absoluteCurrentFieldPath;
    private final LuceneAbstractSearchHighlighter globalHighlighter;
    private final Map<String, LuceneAbstractSearchHighlighter> namedHighlighters;

    public ProjectionRequestContext(ExtractionRequirements.Builder extractionRequirementsBuilder, LuceneAbstractSearchHighlighter globalHighlighter, Map<String, LuceneAbstractSearchHighlighter> namedHighlighters) {
        this(extractionRequirementsBuilder, globalHighlighter, namedHighlighters, null, null);
    }

    private ProjectionRequestContext(ExtractionRequirements.Builder extractionRequirementsBuilder, LuceneAbstractSearchHighlighter globalHighlighter, Map<String, LuceneAbstractSearchHighlighter> namedHighlighters, String absoluteCurrentFieldPath, String absoluteCurrentNestedFieldPath) {
        this.globalHighlighter = globalHighlighter;
        this.namedHighlighters = namedHighlighters;
        this.extractionRequirementsBuilder = extractionRequirementsBuilder;
        this.absoluteCurrentNestedFieldPath = absoluteCurrentNestedFieldPath;
        this.absoluteCurrentFieldPath = absoluteCurrentFieldPath;
    }

    public void requireAllStoredFields() {
        this.extractionRequirementsBuilder.requireAllStoredFields();
    }

    public void requireStoredField(String absoluteFieldPath, String nestedDocumentPath) {
        this.extractionRequirementsBuilder.requireStoredField(absoluteFieldPath, nestedDocumentPath);
    }

    public void requireScore() {
        this.extractionRequirementsBuilder.requireScore();
    }

    public void checkValidField(String absoluteFieldPath) {
        if (!FieldPaths.isStrictPrefix((String)this.absoluteCurrentNestedFieldPath, (String)absoluteFieldPath)) {
            throw log.invalidContextForProjectionOnField(absoluteFieldPath, this.absoluteCurrentNestedFieldPath);
        }
    }

    void checkNotNested(SearchQueryElementTypeKey<?> projectionKey, String hint) {
        if (this.absoluteCurrentFieldPath() != null) {
            throw log.cannotUseProjectionInNestedContext(projectionKey.toString(), hint, EventContexts.indexSchemaRoot());
        }
    }

    public ProjectionRequestContext root() {
        return new ProjectionRequestContext(this.extractionRequirementsBuilder, this.globalHighlighter, this.namedHighlighters);
    }

    public ProjectionRequestContext forField(String absoluteFieldPath, boolean nestedObject) {
        this.checkValidField(absoluteFieldPath);
        return new ProjectionRequestContext(this.extractionRequirementsBuilder, this.globalHighlighter, this.namedHighlighters, absoluteFieldPath, nestedObject ? absoluteFieldPath : this.absoluteCurrentFieldPath);
    }

    public String absoluteCurrentNestedFieldPath() {
        return this.absoluteCurrentNestedFieldPath;
    }

    public String absoluteCurrentFieldPath() {
        return this.absoluteCurrentFieldPath;
    }

    public LuceneAbstractSearchHighlighter highlighter(String name) {
        if (name == null) {
            return this.globalHighlighter == null ? LuceneAbstractSearchHighlighter.defaultHighlighter() : this.globalHighlighter;
        }
        LuceneAbstractSearchHighlighter highlighter = this.namedHighlighters.get(name);
        if (highlighter == null) {
            throw log.cannotFindHighlighterWithName(name, this.namedHighlighters.keySet());
        }
        return highlighter;
    }
}

