/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.Arrays;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.engine.search.projection.spi.ProjectionCompositor;

class ElasticsearchCompositeProjection<E, V, A, P>
extends AbstractElasticsearchProjection<P> {
    private final ElasticsearchSearchProjection<?>[] inners;
    private final ProjectionCompositor<E, V> compositor;
    private final ProjectionAccumulator<E, V, A, P> accumulator;

    public ElasticsearchCompositeProjection(Builder builder, ElasticsearchSearchProjection<?>[] inners, ProjectionCompositor<E, V> compositor, ProjectionAccumulator<E, V, A, P> accumulator) {
        super(builder.scope);
        this.inners = inners;
        this.compositor = compositor;
        this.accumulator = accumulator;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[inners=" + Arrays.toString(this.inners) + ", compositor=" + this.compositor + ", accumulator=" + this.accumulator + "]";
    }

    @Override
    public ElasticsearchSearchProjection.Extractor<A, P> request(JsonObject requestBody, ProjectionRequestContext context) {
        ElasticsearchSearchProjection.Extractor[] innerExtractors = new ElasticsearchSearchProjection.Extractor[this.inners.length];
        for (int i = 0; i < this.inners.length; ++i) {
            innerExtractors[i] = this.inners[i].request(requestBody, context);
        }
        return new CompositeExtractor(innerExtractors);
    }

    static class Builder
    implements CompositeProjectionBuilder {
        private final ElasticsearchSearchIndexScope<?> scope;

        Builder(ElasticsearchSearchIndexScope<?> scope) {
            this.scope = scope;
        }

        public <E, V, P> SearchProjection<P> build(SearchProjection<?>[] inners, ProjectionCompositor<E, V> compositor, ProjectionAccumulator.Provider<V, P> accumulatorProvider) {
            ElasticsearchSearchProjection[] typedInners = new ElasticsearchSearchProjection[inners.length];
            for (int i = 0; i < inners.length; ++i) {
                typedInners[i] = ElasticsearchSearchProjection.from(this.scope, inners[i]);
            }
            return new ElasticsearchCompositeProjection(this, typedInners, compositor, accumulatorProvider.get());
        }
    }

    private class CompositeExtractor
    implements ElasticsearchSearchProjection.Extractor<A, P> {
        private final ElasticsearchSearchProjection.Extractor<?, ?>[] inners;

        private CompositeExtractor(ElasticsearchSearchProjection.Extractor<?, ?>[] inners) {
            this.inners = inners;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[inners=" + Arrays.toString(this.inners) + ", compositor=" + ElasticsearchCompositeProjection.this.compositor + ", accumulator=" + ElasticsearchCompositeProjection.this.accumulator + "]";
        }

        @Override
        public A extract(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonObject source, ProjectionExtractContext context) {
            Object accumulated = ElasticsearchCompositeProjection.this.accumulator.createInitial();
            Object components = ElasticsearchCompositeProjection.this.compositor.createInitial();
            for (int i = 0; i < this.inners.length; ++i) {
                Object extractedDataForInner = this.inners[i].extract(projectionHitMapper, hit, source, context);
                components = ElasticsearchCompositeProjection.this.compositor.set(components, i, extractedDataForInner);
            }
            accumulated = ElasticsearchCompositeProjection.this.accumulator.accumulate(accumulated, components);
            return accumulated;
        }

        @Override
        public final P transform(LoadingResult<?> loadingResult, A accumulated, ProjectionTransformContext context) {
            for (int i = 0; i < ElasticsearchCompositeProjection.this.accumulator.size(accumulated); ++i) {
                Object transformedData = ElasticsearchCompositeProjection.this.accumulator.get(accumulated, i);
                for (int j = 0; j < this.inners.length; ++j) {
                    Object extractedDataForInner = ElasticsearchCompositeProjection.this.compositor.get(transformedData, j);
                    Object transformedDataForInner = ElasticsearchSearchProjection.Extractor.transformUnsafe(this.inners[j], loadingResult, extractedDataForInner, context);
                    transformedData = ElasticsearchCompositeProjection.this.compositor.set(transformedData, j, transformedDataForInner);
                }
                accumulated = ElasticsearchCompositeProjection.this.accumulator.transform(accumulated, i, ElasticsearchCompositeProjection.this.compositor.finish(transformedData));
            }
            return ElasticsearchCompositeProjection.this.accumulator.finish(accumulated);
        }
    }
}

