/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import jakarta.transaction.TransactionManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.BaseStream;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.filter.AcceptAllKeyValueFilter;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.hibernate.cache.commons.util.EvictAllCommand;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.VoidResponseCollector;
import org.infinispan.util.ByteString;

public class Caches {
    private Caches() {
    }

    public static <T> T withinTx(AdvancedCache cache, Callable<T> c) throws Exception {
        return Caches.withinTx(cache.getTransactionManager(), c);
    }

    public static <T> T withinTx(TransactionManager tm, Callable<T> c) throws Exception {
        if (tm == null) {
            return c.call();
        }
        tm.begin();
        try {
            T e = c.call();
            return e;
        }
        catch (Exception e) {
            tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (tm.getStatus() == 0) {
                tm.commit();
            } else {
                tm.rollback();
            }
        }
    }

    public static void withinTx(TransactionManager tm, final Runnable runnable) throws Exception {
        Caches.withinTx(tm, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    public static AdvancedCache localCache(AdvancedCache cache) {
        return cache.withFlags(Flag.CACHE_MODE_LOCAL);
    }

    public static AdvancedCache ignoreReturnValuesCache(AdvancedCache cache) {
        return cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES});
    }

    public static AdvancedCache ignoreReturnValuesCache(AdvancedCache cache, Flag extraFlag) {
        return cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP, Flag.IGNORE_RETURN_VALUES, extraFlag});
    }

    public static AdvancedCache asyncWriteCache(AdvancedCache cache, Flag extraFlag) {
        return cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP, Flag.FORCE_ASYNCHRONOUS, extraFlag});
    }

    public static AdvancedCache failSilentWriteCache(AdvancedCache cache) {
        return cache.withFlags(new Flag[]{Flag.FAIL_SILENTLY, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP});
    }

    public static AdvancedCache failSilentWriteCache(AdvancedCache cache, Flag extraFlag) {
        return cache.withFlags(new Flag[]{Flag.FAIL_SILENTLY, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.SKIP_CACHE_LOAD, Flag.SKIP_REMOTE_LOOKUP, extraFlag});
    }

    public static AdvancedCache failSilentReadCache(AdvancedCache cache) {
        return cache.withFlags(new Flag[]{Flag.FAIL_SILENTLY, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT});
    }

    public static void broadcastEvictAll(AdvancedCache cache) {
        RpcManager rpcManager = cache.getRpcManager();
        if (rpcManager != null) {
            EvictAllCommand cmd = new EvictAllCommand(ByteString.fromString((String)cache.getName()));
            if (Caches.isSynchronousCache(cache)) {
                rpcManager.blocking(rpcManager.invokeCommandOnAll((ReplicableCommand)cmd, (ResponseCollector)VoidResponseCollector.validOnly(), rpcManager.getSyncRpcOptions()));
            } else {
                rpcManager.sendToAll((ReplicableCommand)cmd, DeliverOrder.PER_SENDER);
            }
        }
    }

    public static boolean isInvalidationCache(AdvancedCache cache) {
        return cache.getCacheConfiguration().clustering().cacheMode().isInvalidation();
    }

    public static boolean isSynchronousCache(AdvancedCache cache) {
        return cache.getCacheConfiguration().clustering().cacheMode().isSynchronous();
    }

    public static boolean isClustered(AdvancedCache cache) {
        return cache.getCacheConfiguration().clustering().cacheMode().isClustered();
    }

    public static boolean isTransactionalCache(AdvancedCache cache) {
        return cache.getCacheConfiguration().transaction().transactionMode().isTransactional();
    }

    public static void removeAll(AdvancedCache cache) {
        try (CloseableIterator it = cache.keySet().iterator();){
            while (it.hasNext()) {
                cache.remove(it.next());
            }
        }
    }

    public static <K, V> MapCollectableCloseableIterable<K, V> entrySet(AdvancedCache<K, V> cache) {
        return Caches.entrySet(cache, AcceptAllKeyValueFilter.getInstance());
    }

    public static <K, V> MapCollectableCloseableIterable<K, V> entrySet(AdvancedCache<K, V> cache, KeyValueFilter<K, V> filter) {
        if (cache.getCacheConfiguration().transaction().transactionMode().isTransactional()) {
            cache.containsKey((Object)false);
        }
        CloseableIterator iterator = Closeables.iterator((BaseStream)cache.cacheEntrySet().stream().filter(CacheFilters.predicate(filter)));
        return new MapCollectableCloseableIterableImpl(iterator);
    }

    public static <K, V, T> MapCollectableCloseableIterable<K, T> entrySet(AdvancedCache<K, V> cache, KeyValueFilter<K, V> filter, Converter<K, V, T> converter) {
        if (cache.getCacheConfiguration().transaction().transactionMode().isTransactional()) {
            cache.containsKey((Object)false);
        }
        CloseableIterator it = Closeables.iterator((BaseStream)cache.cacheEntrySet().stream().filter(CacheFilters.predicate(filter)).map(CacheFilters.function(converter)));
        return new MapCollectableCloseableIterableImpl(it);
    }

    public static interface MapCollectableCloseableIterable<K, V>
    extends CloseableIterable<CacheEntry<K, V>> {
        public Map<K, V> toMap();
    }

    private static class MapCollectableCloseableIterableImpl<K, V>
    implements MapCollectableCloseableIterable<K, V> {
        private final CloseableIterator<CacheEntry<K, V>> it;

        public MapCollectableCloseableIterableImpl(CloseableIterator<CacheEntry<K, V>> it) {
            this.it = it;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<K, V> toMap() {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            try {
                while (this.it.hasNext()) {
                    CacheEntry entry = (CacheEntry)this.it.next();
                    Object value = entry.getValue();
                    if (value == null) continue;
                    map.put(entry.getKey(), value);
                }
                HashMap<Object, Object> hashMap = map;
                return hashMap;
            }
            finally {
                this.it.close();
            }
        }

        public String toString() {
            try {
                if (!this.it.hasNext()) {
                    String string = "{}";
                    return string;
                }
                StringBuilder sb = new StringBuilder();
                sb.append('{');
                while (true) {
                    CacheEntry entry = (CacheEntry)this.it.next();
                    sb.append(entry.getKey()).append('=').append(entry.getValue());
                    if (!this.it.hasNext()) {
                        String string = sb.append('}').toString();
                        return string;
                    }
                    sb.append(',').append(' ');
                }
            }
            finally {
                this.it.close();
            }
        }

        public void close() {
            this.it.close();
        }

        public CloseableIterator<CacheEntry<K, V>> iterator() {
            return this.it;
        }
    }

    private static class CollectableCloseableIterableImpl<K, V, T>
    implements CollectableCloseableIterable<T> {
        private final CloseableIterable<CacheEntry<K, V>> entryIterable;
        private final Selector<K, V, T> selector;

        public CollectableCloseableIterableImpl(CloseableIterable<CacheEntry<K, V>> entryIterable, Selector<K, V, T> selector) {
            this.entryIterable = entryIterable;
            this.selector = selector;
        }

        public void close() {
            this.entryIterable.close();
        }

        public CloseableIterator<T> iterator() {
            final CloseableIterator entryIterator = this.entryIterable.iterator();
            return new CloseableIterator<T>(){

                public void close() {
                    entryIterator.close();
                }

                public boolean hasNext() {
                    return entryIterator.hasNext();
                }

                public T next() {
                    return selector.apply((CacheEntry)entryIterator.next());
                }

                public void remove() {
                    throw new UnsupportedOperationException("remove() not supported");
                }
            };
        }

        public String toString() {
            try (CloseableIterator it = this.entryIterable.iterator();){
                if (!it.hasNext()) {
                    String string = "[]";
                    return string;
                }
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                while (true) {
                    CacheEntry entry = (CacheEntry)it.next();
                    sb.append(this.selector.apply(entry));
                    if (!it.hasNext()) {
                        String string = sb.append(']').toString();
                        return string;
                    }
                    sb.append(',').append(' ');
                }
            }
        }

        @Override
        public Set toSet() {
            HashSet<Object> set = new HashSet<Object>();
            try (CloseableIterator<T> it = this.iterator();){
                while (it.hasNext()) {
                    set.add(it.next());
                }
            }
            return set;
        }
    }

    private static interface Selector<K, V, T> {
        public static final Selector KEY = new Selector<Object, Void, Object>(){

            @Override
            public Object apply(CacheEntry<Object, Void> entry) {
                return entry.getKey();
            }
        };
        public static final Selector VALUE = new Selector<Object, Object, Object>(){

            @Override
            public Object apply(CacheEntry<Object, Object> entry) {
                return entry.getValue();
            }
        };

        public T apply(CacheEntry<K, V> var1);
    }

    public static interface CollectableCloseableIterable<T>
    extends CloseableIterable<T> {
        public Set<T> toSet();
    }
}

