/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.deployments.resources;

import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.deployments.LoggingConfigurationService;
import org.jboss.as.logging.deployments.resources.HandlerResourceDefinition;
import org.jboss.as.logging.deployments.resources.LoggerResourceDefinition;
import org.jboss.as.logging.deployments.resources.LoggingConfigurationReadStepHandler;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.ObjectConfigurable;
import org.jboss.logmanager.config.PropertyConfigurable;

public class LoggingDeploymentResources {
    public static final SimpleResourceDefinition CONFIGURATION = new SimpleResourceDefinition(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"configuration"), LoggingExtension.getResourceDescriptionResolver("deployment")).setRuntime());
    public static final SimpleResourceDefinition HANDLER = new HandlerResourceDefinition();
    public static final SimpleResourceDefinition LOGGER = new LoggerResourceDefinition();
    public static final SimpleResourceDefinition FORMATTER = new PropertiesResourceDefinition("formatter"){

        @Override
        protected PropertyConfigurable getPropertyConfigurable(LogContextConfiguration logContextConfiguration, String name) {
            return logContextConfiguration.getFormatterConfiguration(name);
        }

        @Override
        protected ObjectConfigurable getObjectConfigurable(LogContextConfiguration logContextConfiguration, String name) {
            return logContextConfiguration.getFormatterConfiguration(name);
        }
    };
    public static final SimpleResourceDefinition FILTER = new PropertiesResourceDefinition("filter"){

        @Override
        protected PropertyConfigurable getPropertyConfigurable(LogContextConfiguration logContextConfiguration, String name) {
            return logContextConfiguration.getFilterConfiguration(name);
        }

        @Override
        protected ObjectConfigurable getObjectConfigurable(LogContextConfiguration logContextConfiguration, String name) {
            return logContextConfiguration.getFilterConfiguration(name);
        }
    };
    public static final SimpleResourceDefinition POJO = new PropertiesResourceDefinition("pojo"){

        @Override
        protected PropertyConfigurable getPropertyConfigurable(LogContextConfiguration logContextConfiguration, String name) {
            return logContextConfiguration.getPojoConfiguration(name);
        }

        @Override
        protected ObjectConfigurable getObjectConfigurable(LogContextConfiguration logContextConfiguration, String name) {
            return logContextConfiguration.getPojoConfiguration(name);
        }
    };
    public static final SimpleResourceDefinition ERROR_MANAGER = new PropertiesResourceDefinition("error-manager"){

        @Override
        protected PropertyConfigurable getPropertyConfigurable(LogContextConfiguration logContextConfiguration, String name) {
            return logContextConfiguration.getErrorManagerConfiguration(name);
        }

        @Override
        protected ObjectConfigurable getObjectConfigurable(LogContextConfiguration logContextConfiguration, String name) {
            return logContextConfiguration.getErrorManagerConfiguration(name);
        }
    };

    public static void registerDeploymentResource(DeploymentResourceSupport deploymentResourceSupport, LoggingConfigurationService service) {
        PathElement base = PathElement.pathElement((String)"configuration", (String)service.getConfiguration());
        deploymentResourceSupport.getDeploymentSubModel("logging", base);
        LogContextConfiguration configuration = service.getValue();
        if (configuration != null) {
            LoggingDeploymentResources.registerDeploymentResource(deploymentResourceSupport, base, (ResourceDefinition)HANDLER, configuration.getHandlerNames());
            LoggingDeploymentResources.registerDeploymentResource(deploymentResourceSupport, base, (ResourceDefinition)LOGGER, configuration.getLoggerNames());
            LoggingDeploymentResources.registerDeploymentResource(deploymentResourceSupport, base, (ResourceDefinition)FORMATTER, configuration.getFormatterNames());
            LoggingDeploymentResources.registerDeploymentResource(deploymentResourceSupport, base, (ResourceDefinition)FILTER, configuration.getFilterNames());
            LoggingDeploymentResources.registerDeploymentResource(deploymentResourceSupport, base, (ResourceDefinition)POJO, configuration.getPojoNames());
            LoggingDeploymentResources.registerDeploymentResource(deploymentResourceSupport, base, (ResourceDefinition)ERROR_MANAGER, configuration.getErrorManagerNames());
        }
    }

    private static void registerDeploymentResource(DeploymentResourceSupport deploymentResourceSupport, PathElement base, ResourceDefinition def, Collection<String> names) {
        for (String name : names) {
            String resourceName = name.isEmpty() ? "ROOT" : name;
            PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{base, PathElement.pathElement((String)def.getPathElement().getKey(), (String)resourceName)});
            deploymentResourceSupport.getDeploymentSubModel("logging", address);
        }
    }

    private static abstract class PropertiesResourceDefinition
    extends SimpleResourceDefinition {
        static final SimpleAttributeDefinition CLASS_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"class-name", (ModelType)ModelType.STRING).setStorageRuntime()).build();
        static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING, (boolean)true).setStorageRuntime()).build();
        static final SimpleMapAttributeDefinition PROPERTIES = ((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("properties", ModelType.STRING, true).setStorageRuntime()).build();

        PropertiesResourceDefinition(String name) {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)name), LoggingExtension.getResourceDescriptionResolver("deployment", name)).setRuntime());
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CLASS_NAME, (OperationStepHandler)new LoggingConfigurationReadStepHandler(){

                @Override
                protected void updateModel(LogContextConfiguration logContextConfiguration, String name, ModelNode model) {
                    ObjectConfigurable configuration = this.getObjectConfigurable(logContextConfiguration, name);
                    1.setModelValue(model, configuration.getClassName());
                }
            });
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)MODULE, (OperationStepHandler)new LoggingConfigurationReadStepHandler(){

                @Override
                protected void updateModel(LogContextConfiguration logContextConfiguration, String name, ModelNode model) {
                    ObjectConfigurable configuration = this.getObjectConfigurable(logContextConfiguration, name);
                    2.setModelValue(model, configuration.getModuleName());
                }
            });
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PROPERTIES, (OperationStepHandler)new LoggingConfigurationReadStepHandler(){

                @Override
                protected void updateModel(LogContextConfiguration logContextConfiguration, String name, ModelNode model) {
                    PropertyConfigurable configuration = this.getPropertyConfigurable(logContextConfiguration, name);
                    3.addProperties(configuration, model);
                }
            });
        }

        protected abstract PropertyConfigurable getPropertyConfigurable(LogContextConfiguration var1, String var2);

        protected abstract ObjectConfigurable getObjectConfigurable(LogContextConfiguration var1, String var2);
    }
}

