/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.EAXBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.OCBBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Exceptions;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.io.Streams;

public class BcAEADUtil {
    protected static byte[] getNonce(byte[] byArray, long l) {
        byte[] byArray2 = Arrays.clone((byte[])byArray);
        BcAEADUtil.xorChunkId(byArray2, l);
        return byArray2;
    }

    protected static void xorChunkId(byte[] byArray, long l) {
        int n = byArray.length - 8;
        int n2 = n++;
        byArray[n2] = (byte)(byArray[n2] ^ (byte)(l >> 56));
        int n3 = n++;
        byArray[n3] = (byte)(byArray[n3] ^ (byte)(l >> 48));
        int n4 = n++;
        byArray[n4] = (byte)(byArray[n4] ^ (byte)(l >> 40));
        int n5 = n++;
        byArray[n5] = (byte)(byArray[n5] ^ (byte)(l >> 32));
        int n6 = n++;
        byArray[n6] = (byte)(byArray[n6] ^ (byte)(l >> 24));
        int n7 = n++;
        byArray[n7] = (byte)(byArray[n7] ^ (byte)(l >> 16));
        int n8 = n++;
        byArray[n8] = (byte)(byArray[n8] ^ (byte)(l >> 8));
        int n9 = n;
        byArray[n9] = (byte)(byArray[n9] ^ (byte)l);
    }

    protected static long getChunkLength(int n) {
        return 1L << n + 6;
    }

    static byte[][] deriveMessageKeyAndIv(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) throws PGPException {
        HKDFParameters hKDFParameters = new HKDFParameters(byArray, byArray2, byArray3);
        HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hKDFBytesGenerator.init((DerivationParameters)hKDFParameters);
        int n3 = SymmetricKeyUtils.getKeyLengthInOctets(n2);
        int n4 = AEADUtils.getIVLength(n);
        byte[] byArray4 = new byte[n3 + n4 - 8];
        hKDFBytesGenerator.generateBytes(byArray4, 0, byArray4.length);
        return new byte[][]{Arrays.copyOfRange((byte[])byArray4, (int)0, (int)n3), Arrays.copyOfRange((byte[])byArray4, (int)n3, (int)(n3 + n4))};
    }

    public static AEADBlockCipher createAEADCipher(int n, int n2) throws PGPException {
        if (n != 7 && n != 8 && n != 9) {
            throw new PGPException("AEAD only supported for AES based algorithms");
        }
        switch (n2) {
            case 1: {
                return new EAXBlockCipher((BlockCipher)new AESEngine());
            }
            case 2: {
                return new OCBBlockCipher((BlockCipher)new AESEngine(), (BlockCipher)new AESEngine());
            }
            case 3: {
                return new GCMBlockCipher((BlockCipher)new AESEngine());
            }
        }
        throw new PGPException("unrecognised AEAD algorithm: " + n2);
    }

    static PGPDataDecryptor createOpenPgpV5DataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        final byte by = aEADEncDataPacket.getAEADAlgorithm();
        final byte[] byArray = aEADEncDataPacket.getIV();
        final int n = aEADEncDataPacket.getChunkSize();
        final int n2 = pGPSessionKey.getAlgorithm();
        byte[] byArray2 = pGPSessionKey.getKey();
        final byte[] byArray3 = aEADEncDataPacket.getAAData();
        final KeyParameter keyParameter = new KeyParameter(byArray2);
        final AEADBlockCipher aEADBlockCipher = BcAEADUtil.createAEADCipher(n2, by);
        return new PGPDataDecryptor(){

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                try {
                    return new PGPAeadInputStream(true, inputStream, aEADBlockCipher, keyParameter, byArray, n2, by, n, byArray3);
                }
                catch (IOException iOException) {
                    throw Exceptions.illegalStateException((String)("unable to open stream: " + iOException.getMessage()), (Throwable)iOException);
                }
            }

            @Override
            public int getBlockSize() {
                return aEADBlockCipher.getUnderlyingCipher().getBlockSize();
            }

            @Override
            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    static PGPDataDecryptor createOpenPgpV6DataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        if (symmetricEncIntegrityPacket.getVersion() == 1) {
            throw new PGPException("SEIPD packet MUST be of version 2 or greater.");
        }
        final int n = symmetricEncIntegrityPacket.getCipherAlgorithm();
        final int n2 = symmetricEncIntegrityPacket.getAeadAlgorithm();
        final int n3 = symmetricEncIntegrityPacket.getChunkSize();
        final byte[] byArray = symmetricEncIntegrityPacket.getAAData();
        byte[][] byArray2 = BcAEADUtil.deriveMessageKeyAndIv(n2, n, pGPSessionKey.getKey(), symmetricEncIntegrityPacket.getSalt(), byArray);
        byte[] byArray3 = byArray2[0];
        final byte[] byArray4 = byArray2[1];
        final KeyParameter keyParameter = new KeyParameter(byArray3);
        final AEADBlockCipher aEADBlockCipher = BcAEADUtil.createAEADCipher(n, n2);
        return new PGPDataDecryptor(){

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                try {
                    return new PGPAeadInputStream(false, inputStream, aEADBlockCipher, keyParameter, byArray4, n, n2, n3, byArray);
                }
                catch (IOException iOException) {
                    throw Exceptions.illegalStateException((String)("unable to open stream: " + iOException.getMessage()), (Throwable)iOException);
                }
            }

            @Override
            public int getBlockSize() {
                return aEADBlockCipher.getUnderlyingCipher().getBlockSize();
            }

            @Override
            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    protected static class PGPAeadInputStream
    extends InputStream {
        private final InputStream in;
        private final byte[] buf;
        private final AEADBlockCipher c;
        private final KeyParameter secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private final int tagLen;
        private byte[] data;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;
        private final boolean isV5StyleAEAD;

        public PGPAeadInputStream(boolean bl, InputStream inputStream, AEADBlockCipher aEADBlockCipher, KeyParameter keyParameter, byte[] byArray, int n, int n2, int n3, byte[] byArray2) throws IOException {
            this.isV5StyleAEAD = bl;
            this.in = inputStream;
            this.iv = byArray;
            this.chunkLength = (int)BcAEADUtil.getChunkLength(n3);
            this.tagLen = AEADUtils.getAuthTagLength(n2);
            this.buf = new byte[this.chunkLength + this.tagLen + this.tagLen];
            this.c = aEADBlockCipher;
            this.secretKey = keyParameter;
            this.aaData = byArray2;
            Streams.readFully((InputStream)inputStream, (byte[])this.buf, (int)0, (int)(this.tagLen + this.tagLen));
            this.data = this.readBlock();
            this.dataOff = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data[this.dataOff++] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            int n3 = Math.min(n2, this.available());
            System.arraycopy(this.data, this.dataOff, byArray, n, n3);
            this.dataOff += n3;
            return n3;
        }

        @Override
        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            int n = (int)Math.min(l, (long)this.available());
            this.dataOff += n;
            return n;
        }

        @Override
        public int available() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data.length - this.dataOff;
        }

        private byte[] readBlock() throws IOException {
            int n = Streams.readFully((InputStream)this.in, (byte[])this.buf, (int)(this.tagLen + this.tagLen), (int)this.chunkLength);
            if (n == 0) {
                return null;
            }
            byte[] byArray = new byte[this.isV5StyleAEAD ? 13 : this.aaData.length];
            System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
            if (this.isV5StyleAEAD) {
                BcAEADUtil.xorChunkId(byArray, this.chunkIndex);
            }
            byte[] byArray2 = new byte[n];
            try {
                this.c.init(false, (CipherParameters)new AEADParameters(this.secretKey, 128, BcAEADUtil.getNonce(this.iv, this.chunkIndex)));
                this.c.processAADBytes(byArray, 0, byArray.length);
                int n2 = this.c.processBytes(this.buf, 0, n + this.tagLen, byArray2, 0);
                this.c.doFinal(byArray2, n2);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + invalidCipherTextException.getMessage());
            }
            this.totalBytes += (long)byArray2.length;
            ++this.chunkIndex;
            System.arraycopy(this.buf, n + this.tagLen, this.buf, 0, this.tagLen);
            if (n != this.chunkLength) {
                if (this.isV5StyleAEAD) {
                    byArray = new byte[13];
                    System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
                    BcAEADUtil.xorChunkId(byArray, this.chunkIndex);
                } else {
                    byArray = new byte[this.aaData.length + 8];
                    System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
                    System.arraycopy(Pack.longToBigEndian((long)this.totalBytes), 0, byArray, this.aaData.length, 8);
                }
                try {
                    this.c.init(false, (CipherParameters)new AEADParameters(this.secretKey, 128, BcAEADUtil.getNonce(this.iv, this.chunkIndex)));
                    this.c.processAADBytes(byArray, 0, byArray.length);
                    if (this.isV5StyleAEAD) {
                        this.c.processAADBytes(Pack.longToBigEndian((long)this.totalBytes), 0, 8);
                    }
                    this.c.processBytes(this.buf, 0, this.tagLen, this.buf, 0);
                    this.c.doFinal(this.buf, 0);
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new IOException("exception processing final tag: " + invalidCipherTextException.getMessage());
                }
            } else {
                Streams.readFully((InputStream)this.in, (byte[])this.buf, (int)this.tagLen, (int)this.tagLen);
            }
            return byArray2;
        }
    }

    protected static class PGPAeadOutputStream
    extends OutputStream {
        private final boolean isV5StyleAEAD;
        private final OutputStream out;
        private final byte[] data;
        private final AEADBlockCipher c;
        private final KeyParameter secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private final int tagLen;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadOutputStream(boolean bl, OutputStream outputStream, AEADBlockCipher aEADBlockCipher, KeyParameter keyParameter, byte[] byArray, int n, int n2, int n3) {
            this.isV5StyleAEAD = bl;
            this.out = outputStream;
            this.iv = byArray;
            this.chunkLength = (int)BcAEADUtil.getChunkLength(n3);
            this.tagLen = AEADUtils.getAuthTagLength(n2);
            this.data = new byte[this.chunkLength];
            this.c = aEADBlockCipher;
            this.secretKey = keyParameter;
            this.aaData = this.createAAD(bl, n, n2, n3);
        }

        private byte[] createAAD(boolean bl, int n, int n2, int n3) {
            if (bl) {
                return AEADEncDataPacket.createAAData(1, n, n2, n3);
            }
            return SymmetricEncIntegrityPacket.createAAData(2, n, n2, n3);
        }

        @Override
        public void write(int n) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            this.data[this.dataOff++] = (byte)n;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            if (n2 < this.data.length - this.dataOff) {
                System.arraycopy(byArray, n, this.data, this.dataOff, n2);
                this.dataOff += n2;
            } else {
                int n3 = this.data.length - this.dataOff;
                System.arraycopy(byArray, n, this.data, this.dataOff, n3);
                this.dataOff += n3;
                this.writeBlock();
                n2 -= n3;
                n += n3;
                while (n2 >= this.data.length) {
                    System.arraycopy(byArray, n, this.data, 0, this.data.length);
                    this.dataOff = this.data.length;
                    this.writeBlock();
                    n2 -= this.data.length;
                    n += this.data.length;
                }
                if (n2 > 0) {
                    System.arraycopy(byArray, n, this.data, 0, n2);
                    this.dataOff = n2;
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.finish();
        }

        private void writeBlock() throws IOException {
            boolean bl = this.isV5StyleAEAD;
            byte[] byArray = bl ? new byte[13] : new byte[this.aaData.length];
            System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
            if (bl) {
                BcAEADUtil.xorChunkId(byArray, this.chunkIndex);
            }
            try {
                this.c.init(true, (CipherParameters)new AEADParameters(this.secretKey, 128, BcAEADUtil.getNonce(this.iv, this.chunkIndex)));
                this.c.processAADBytes(byArray, 0, byArray.length);
                int n = this.c.processBytes(this.data, 0, this.dataOff, this.data, 0);
                this.out.write(this.data, 0, n);
                n = this.c.doFinal(this.data, 0);
                this.out.write(this.data, 0, n);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + invalidCipherTextException.getMessage());
            }
            this.totalBytes += (long)this.dataOff;
            ++this.chunkIndex;
            this.dataOff = 0;
        }

        private void finish() throws IOException {
            byte[] byArray;
            boolean bl;
            if (this.dataOff > 0) {
                this.writeBlock();
            }
            if (bl = this.isV5StyleAEAD) {
                byArray = new byte[13];
                System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
                BcAEADUtil.xorChunkId(byArray, this.chunkIndex);
            } else {
                byArray = new byte[this.aaData.length + 8];
                System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
                System.arraycopy(Pack.longToBigEndian((long)this.totalBytes), 0, byArray, this.aaData.length, 8);
            }
            try {
                this.c.init(true, (CipherParameters)new AEADParameters(this.secretKey, 128, BcAEADUtil.getNonce(this.iv, this.chunkIndex)));
                this.c.processAADBytes(byArray, 0, byArray.length);
                if (bl) {
                    this.c.processAADBytes(Pack.longToBigEndian((long)this.totalBytes), 0, 8);
                }
                this.c.doFinal(this.data, 0);
                this.out.write(this.data, 0, this.tagLen);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new IOException("exception processing final tag: " + invalidCipherTextException.getMessage());
            }
            this.out.close();
        }
    }
}

