/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.AccessLogAdd;
import org.wildfly.extension.undertow.UndertowService;

class AccessLogRemove
extends AbstractRemoveStepHandler {
    public static final AccessLogRemove INSTANCE = new AccessLogRemove();

    AccessLogRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress hostAddress = context.getCurrentAddress().getParent();
        PathAddress serverAddress = hostAddress.getParent();
        String hostName = hostAddress.getLastElement().getValue();
        String serverName = serverAddress.getLastElement().getValue();
        ServiceName serviceName = UndertowService.accessLogServiceName(serverName, hostName);
        context.removeService(serviceName);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        AccessLogAdd.INSTANCE.performRuntime(context, operation, model);
    }
}

