/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse;

import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.sse.OutboundSseEvent;
import java.lang.reflect.Type;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class OutboundSseEventImpl
implements OutboundSseEvent {
    private final String name;
    private final String comment;
    private final String id;
    private final Class<?> type;
    private final Type genericType;
    private MediaType mediaType;
    private boolean mediaTypeSet;
    private final Object data;
    private final long reconnectDelay;
    private boolean escape = false;

    OutboundSseEventImpl(String name, String id, long reconnectDelay, Class<?> type, Type genericType, MediaType mediaType, Object data, String comment) {
        this.name = name;
        this.comment = comment;
        this.id = id;
        this.reconnectDelay = reconnectDelay;
        this.type = type;
        this.genericType = genericType;
        this.mediaType = mediaType;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public boolean isReconnectDelaySet() {
        return this.reconnectDelay > -1L;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public boolean isMediaTypeSet() {
        return this.mediaTypeSet;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        this.mediaTypeSet = true;
    }

    public String getComment() {
        return this.comment;
    }

    public Object getData() {
        return this.data;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public void setEscape(Boolean escape) {
        this.escape = escape;
    }

    public static class BuilderImpl
    implements OutboundSseEvent.Builder {
        private String name;
        private String comment;
        private String id;
        private long reconnectDelay = -1L;
        private Class<?> type;
        private Type genericType;
        private Object data;
        private MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;

        public OutboundSseEvent.Builder name(String name) {
            this.name = name;
            return this;
        }

        public OutboundSseEvent.Builder id(String id) {
            this.id = id;
            return this;
        }

        public OutboundSseEvent.Builder reconnectDelay(long milliseconds) {
            if (milliseconds < 0L) {
                milliseconds = -1L;
            }
            this.reconnectDelay = milliseconds;
            return this;
        }

        public OutboundSseEvent.Builder mediaType(MediaType mediaType) {
            if (mediaType == null) {
                throw new NullPointerException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("mediaType"));
            }
            this.mediaType = mediaType;
            return this;
        }

        public OutboundSseEvent.Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public OutboundSseEvent.Builder data(Class type, Object data) {
            if (type == null) {
                throw new NullPointerException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("type"));
            }
            if (data == null) {
                throw new NullPointerException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("data"));
            }
            this.type = type;
            this.genericType = type;
            this.data = data;
            return this;
        }

        public OutboundSseEvent.Builder data(GenericType type, Object data) {
            if (type == null) {
                throw new NullPointerException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("type"));
            }
            if (data == null) {
                throw new NullPointerException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("data"));
            }
            this.type = type.getRawType();
            this.genericType = type.getType();
            this.data = data;
            return this;
        }

        public OutboundSseEvent.Builder data(Object data) {
            if (data == null) {
                throw new NullPointerException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("data"));
            }
            if (data instanceof GenericEntity) {
                GenericEntity genericEntity = (GenericEntity)data;
                this.type = genericEntity.getRawType();
                this.genericType = genericEntity.getType();
                this.data = genericEntity.getEntity();
            } else {
                this.data(data.getClass(), data);
            }
            return this;
        }

        public OutboundSseEvent build() {
            if (this.comment == null && this.data == null) {
                throw new IllegalArgumentException(Messages.MESSAGES.nullValueSetToCreateOutboundSseEvent("comment or data"));
            }
            return new OutboundSseEventImpl(this.name, this.id, this.reconnectDelay, this.type, this.genericType, this.mediaType, this.data, this.comment);
        }
    }
}

