/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.star.resource;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.RecordListIterator;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.jboss.jbossts.star.provider.HttpResponseException;
import org.jboss.jbossts.star.resource.RESTRecord;
import org.jboss.jbossts.star.service.Coordinator;
import org.jboss.jbossts.star.util.TxStatus;
import org.jboss.jbossts.star.util.TxSupport;
import org.jboss.jbossts.star.util.media.txstatusext.CoordinatorElement;
import org.jboss.jbossts.star.util.media.txstatusext.TransactionStatusElement;
import org.jboss.jbossts.star.util.media.txstatusext.TwoPhaseAwareParticipantElement;
import org.jboss.logging.Logger;

@XmlRootElement(name="transaction")
public class Transaction
extends AtomicAction {
    protected static final Logger log = Logger.getLogger(Transaction.class);
    private long age = System.currentTimeMillis();
    private Coordinator coordinator = null;
    private String initiator;
    private String recoveryUrl = null;
    private Collection<String> volatileParticipants = new ArrayList<String>();
    private Collection<String> enlistmentIds;

    public Transaction() {
    }

    public Transaction(Coordinator coordinator, String initiator) {
        this();
        this.coordinator = coordinator;
        this.initiator = initiator;
    }

    public Transaction(Uid uid) {
        super(uid);
    }

    public CoordinatorElement toXML() {
        CoordinatorElement coordinatorElement = new CoordinatorElement();
        coordinatorElement.setCreated(new Date(System.currentTimeMillis() - this.age));
        coordinatorElement.setStatus(TransactionStatusElement.valueOf((String)this.getStatus()));
        coordinatorElement.setTimeout((long)this.getTimeout());
        for (String vParticipant : this.volatileParticipants) {
            coordinatorElement.addVolatileParticipant(vParticipant);
        }
        return coordinatorElement;
    }

    @XmlElement
    public String getInitiator() {
        return this.initiator;
    }

    @XmlElement
    public String getAge() {
        return Long.toString(System.currentTimeMillis() - this.age);
    }

    @XmlAttribute
    public String getStatus() {
        return this.getStatus(this.lookupStatus());
    }

    protected int lookupStatus() {
        return this.status();
    }

    public String getStatus(int status) {
        TxStatus txStatus = TxStatus.fromActionStatus((int)status);
        if (txStatus.equals((Object)TxStatus.TransactionStatusUnknown)) {
            return "";
        }
        return txStatus.name();
    }

    public TxStatus getTxStatus() {
        return TxStatus.fromActionStatus((int)this.lookupStatus());
    }

    public String getRecoveryUrl() {
        return this.recoveryUrl;
    }

    public String enlistParticipant(String coordinatorUrl, String participantUrl, String recoveryUrlBase, String terminateUrl) {
        if (this.findParticipant(participantUrl) != null) {
            return null;
        }
        String txId = this.get_uid().fileStringForm();
        RESTRecord p = new RESTRecord(txId, coordinatorUrl, participantUrl, terminateUrl);
        String coordinatorId = p.get_uid().fileStringForm();
        this.recoveryUrl = recoveryUrlBase + txId + "/" + coordinatorId;
        p.setRecoveryURI(this.recoveryUrl);
        if (this.add(p) != 3) {
            return coordinatorId;
        }
        return null;
    }

    public String enlistParticipant(String coordinatorUrl, String participantUrl, String recoveryUrlBase, String commitURI, String prepareURI, String rollbackURI, String commitOnePhaseURI) {
        if (this.findParticipant(participantUrl) != null) {
            return null;
        }
        String txId = this.get_uid().fileStringForm();
        RESTRecord p = new RESTRecord(txId, coordinatorUrl, participantUrl, commitURI, prepareURI, rollbackURI, commitOnePhaseURI);
        String coordinatorId = p.get_uid().fileStringForm();
        this.recoveryUrl = recoveryUrlBase + txId + "/" + coordinatorId;
        p.setRecoveryURI(this.recoveryUrl);
        if (this.add(p) != 3) {
            return coordinatorId;
        }
        return null;
    }

    public boolean isEnlisted(String participantUrl) {
        return this.findParticipant(participantUrl) != null;
    }

    public boolean forgetParticipant(String participantUrl) {
        RESTRecord rr = this.findParticipant(participantUrl);
        if (rr != null) {
            return this.pendingList.remove((AbstractRecord)rr);
        }
        return false;
    }

    public void getParticipants(Collection<String> enlistmentIds) {
        if (this.pendingList == null) {
            return;
        }
        AbstractRecord r = this.pendingList.peekFront();
        while (r != null) {
            if (r instanceof RESTRecord) {
                enlistmentIds.add(r.get_uid().fileStringForm());
            }
            r = this.pendingList.peekNext(r);
        }
    }

    public void setFault(String fault) {
        if (this.pendingList == null) {
            return;
        }
        AbstractRecord r = this.pendingList.peekFront();
        while (r != null) {
            if (r instanceof RESTRecord) {
                ((RESTRecord)r).setFault(fault);
            }
            r = this.pendingList.peekNext(r);
        }
    }

    public boolean isFinishing() {
        return this.getTxStatus().isFinishing();
    }

    public boolean isAlive() {
        return this.getTxStatus().isActive();
    }

    public boolean isRunning() {
        return this.getTxStatus().isRunning();
    }

    private RESTRecord findParticipant(String participantUrl) {
        if (this.pendingList != null) {
            AbstractRecord r;
            RecordListIterator i = new RecordListIterator(this.pendingList);
            while ((r = i.iterate()) != null) {
                RESTRecord rr;
                if (!(r instanceof RESTRecord) || !(rr = (RESTRecord)r).getParticipantURI().equals(participantUrl)) continue;
                return rr;
            }
        }
        return null;
    }

    public boolean getStatus(TwoPhaseAwareParticipantElement participantElement, String participantUrl) {
        RESTRecord rr = this.findParticipant(participantUrl);
        if (rr == null) {
            return false;
        }
        try {
            participantElement.setStatus(TransactionStatusElement.valueOf((String)rr.getStatus()));
        }
        catch (IllegalArgumentException e) {
            participantElement.setStatus(TransactionStatusElement.TransactionStatusNone);
        }
        participantElement.setCreated(new Date(rr.getAge()));
        return true;
    }

    public void addVolatileParticipant(String vparticipantURI) {
        this.volatileParticipants.add(vparticipantURI);
    }

    protected boolean beforeCompletion() {
        boolean commit = true;
        for (String uri : this.volatileParticipants) {
            try {
                new TxSupport().httpRequest(new int[]{200}, uri, "PUT", null);
            }
            catch (HttpResponseException e) {
                commit = false;
                if (!log.isDebugEnabled()) continue;
                log.debugf((Throwable)e, "volatile participant %s error %s during beforeCompletion", (Object)uri, (Object)e.getMessage());
            }
        }
        if (!super.beforeCompletion()) {
            commit = false;
        }
        this.enlistmentIds = new ArrayList<String>();
        this.getParticipants(this.enlistmentIds);
        return commit;
    }

    protected boolean afterCompletion(int arjunaStatus) {
        return this.afterCompletion(arjunaStatus, false);
    }

    protected boolean afterCompletion(int arjunaStatus, boolean report_heuristics) {
        if (this.volatileParticipants.size() != 0) {
            String status = TxSupport.toStatusContent((String)TxStatus.fromActionStatus((int)arjunaStatus).name());
            for (String uri : this.volatileParticipants) {
                try {
                    new TxSupport().httpRequest(new int[]{200}, uri, "PUT", "application/txstatus", status);
                }
                catch (HttpResponseException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debugf((Throwable)e, "volatile participant %s error %s during afterCompletion", (Object)uri, (Object)e.getMessage());
                }
            }
        }
        if (this.failedList == null || this.failedList.size() == 0) {
            this.coordinator.removeTxState(arjunaStatus, this, this.enlistmentIds);
        }
        return super.afterCompletion(arjunaStatus, report_heuristics);
    }
}

