/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session;

import java.util.AbstractMap;
import java.util.Map;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSession;
import org.wildfly.clustering.web.cache.session.CompositeImmutableSessionFactory;
import org.wildfly.clustering.web.cache.session.CompositeSession;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.cache.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.Session;

public class CompositeSessionFactory<C, V, L>
extends CompositeImmutableSessionFactory<V, L>
implements SessionFactory<C, CompositeSessionMetaDataEntry<L>, V, L> {
    private final SessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> metaDataFactory;
    private final SessionAttributesFactory<C, V> attributesFactory;
    private final LocalContextFactory<L> localContextFactory;

    public CompositeSessionFactory(SessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> metaDataFactory, SessionAttributesFactory<C, V> attributesFactory, LocalContextFactory<L> localContextFactory) {
        super(metaDataFactory, attributesFactory);
        this.metaDataFactory = metaDataFactory;
        this.attributesFactory = attributesFactory;
        this.localContextFactory = localContextFactory;
    }

    public Map.Entry<CompositeSessionMetaDataEntry<L>, V> createValue(String id, SessionCreationMetaData creationMetaData) {
        CompositeSessionMetaDataEntry metaDataValue = (CompositeSessionMetaDataEntry)this.metaDataFactory.createValue(id, creationMetaData);
        if (metaDataValue == null) {
            return null;
        }
        Object attributesValue = this.attributesFactory.createValue(id, null);
        return new AbstractMap.SimpleImmutableEntry<CompositeSessionMetaDataEntry, Object>(metaDataValue, attributesValue);
    }

    @Override
    public Map.Entry<CompositeSessionMetaDataEntry<L>, V> findValue(String id) {
        CompositeSessionMetaDataEntry metaDataValue = (CompositeSessionMetaDataEntry)this.metaDataFactory.findValue(id);
        if (metaDataValue != null) {
            Object attributesValue = this.attributesFactory.findValue(id);
            if (attributesValue != null) {
                return new AbstractMap.SimpleImmutableEntry<CompositeSessionMetaDataEntry, Object>(metaDataValue, attributesValue);
            }
            this.metaDataFactory.purge(id);
        }
        return null;
    }

    @Override
    public Map.Entry<CompositeSessionMetaDataEntry<L>, V> tryValue(String id) {
        Object attributesValue;
        CompositeSessionMetaDataEntry metaDataValue = (CompositeSessionMetaDataEntry)this.metaDataFactory.tryValue(id);
        if (metaDataValue != null && (attributesValue = this.attributesFactory.tryValue(id)) != null) {
            return new AbstractMap.SimpleImmutableEntry<CompositeSessionMetaDataEntry, Object>(metaDataValue, attributesValue);
        }
        return null;
    }

    public boolean remove(String id) {
        this.attributesFactory.remove(id);
        return this.metaDataFactory.remove(id);
    }

    public boolean purge(String id) {
        this.attributesFactory.purge(id);
        return this.metaDataFactory.purge(id);
    }

    @Override
    public SessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> getMetaDataFactory() {
        return this.metaDataFactory;
    }

    @Override
    public SessionAttributesFactory<C, V> getAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public Session<L> createSession(String id, Map.Entry<CompositeSessionMetaDataEntry<L>, V> entry, C context) {
        CompositeSessionMetaDataEntry<L> key = entry.getKey();
        InvalidatableSessionMetaData metaData = this.metaDataFactory.createSessionMetaData(id, key);
        SessionAttributes attributes = this.attributesFactory.createSessionAttributes(id, entry.getValue(), (ImmutableSessionMetaData)metaData, context);
        return new CompositeSession<L>(id, metaData, attributes, key.getLocalContext(), this.localContextFactory, this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, ImmutableSessionMetaData metaData, ImmutableSessionAttributes attributes) {
        return new CompositeImmutableSession(id, metaData, attributes);
    }

    @Override
    public void close() {
        this.metaDataFactory.close();
        this.attributesFactory.close();
    }
}

