/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import org.jboss.common.beans.property.BeanUtils;
import org.jboss.common.beans.property.PropertyEditorSupport;

public class URIEditor
extends PropertyEditorSupport<URI> {
    public URIEditor() {
        super(URI.class);
    }

    @Override
    public void setAsText(String text) {
        if (BeanUtils.isNull(text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(URIEditor.toURI(text));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse to URI!", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed to parse to URI!", e);
        }
    }

    @Override
    public String getAsText() {
        URI u = (URI)this.getValue();
        if (u == null) {
            return null;
        }
        String stringValue = u.toString();
        if (stringValue.startsWith("file")) {
            try {
                stringValue = URLDecoder.decode(stringValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Failed to parse to URI!", e);
            }
        }
        return stringValue;
    }

    public static URI toURI(String urispec) throws URISyntaxException, UnsupportedEncodingException {
        URI uri = (urispec = urispec.trim()).startsWith("file:") ? URIEditor.makeURIFromFilespec(urispec.substring(5)) : new URI(urispec);
        return uri;
    }

    private static URI makeURIFromFilespec(String filespec) throws UnsupportedEncodingException {
        String decoded = URLDecoder.decode(filespec, "UTF-8");
        File file = new File(decoded);
        return file.toURI();
    }
}

