/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal.stax;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.hibernate.boot.ResourceStreamLocator;
import org.hibernate.boot.jaxb.internal.stax.LocalSchemaLocator;
import org.hibernate.boot.jaxb.internal.stax.XmlInfrastructureException;
import org.hibernate.boot.xsd.ConfigXsdSupport;
import org.hibernate.boot.xsd.MappingXsdSupport;
import org.hibernate.boot.xsd.XsdDescriptor;
import org.hibernate.internal.log.DeprecationLogger;
import org.jboss.logging.Logger;

public class LocalXmlResourceResolver
implements XMLResolver {
    private static final Logger log = Logger.getLogger(LocalXmlResourceResolver.class);
    public static final String CLASSPATH_EXTENSION_URL_BASE = "classpath://";
    private final ResourceStreamLocator resourceStreamLocator;
    public static final DtdDescriptor MAPPING_DTD = new DtdDescriptor("www.hibernate.org/dtd/hibernate-mapping", "org/hibernate/hibernate-mapping-3.0.dtd");
    public static final DtdDescriptor ALTERNATE_MAPPING_DTD = new DtdDescriptor("hibernate.org/dtd/hibernate-mapping", "org/hibernate/hibernate-mapping-3.0.dtd");
    public static final DtdDescriptor LEGACY_MAPPING_DTD = new DtdDescriptor("hibernate.sourceforge.net/hibernate-mapping", "org/hibernate/hibernate-mapping-3.0.dtd");
    public static final DtdDescriptor CFG_DTD = new DtdDescriptor("www.hibernate.org/dtd/hibernate-configuration", "org/hibernate/hibernate-configuration-3.0.dtd");
    public static final DtdDescriptor ALTERNATE_CFG_DTD = new DtdDescriptor("hibernate.org/dtd/hibernate-configuration", "org/hibernate/hibernate-configuration-3.0.dtd");
    public static final DtdDescriptor LEGACY_CFG_DTD = new DtdDescriptor("hibernate.sourceforge.net/hibernate-configuration", "org/hibernate/hibernate-configuration-3.0.dtd");

    public LocalXmlResourceResolver(ResourceStreamLocator resourceStreamLocator) {
        this.resourceStreamLocator = resourceStreamLocator;
    }

    @Override
    public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
        log.tracef("In resolveEntity(%s, %s, %s, %s)", new Object[]{publicID, systemID, baseURI, namespace});
        if (namespace != null) {
            log.debugf("Interpreting namespace : %s", (Object)namespace);
            if (MappingXsdSupport._310.getNamespaceUri().matches(namespace)) {
                return this.openUrlStream(MappingXsdSupport._310);
            }
            if (MappingXsdSupport.jpa10.getNamespaceUri().matches(namespace)) {
                return this.openUrlStream(MappingXsdSupport.jpa10);
            }
            if (MappingXsdSupport.jpa21.getNamespaceUri().matches(namespace)) {
                return this.openUrlStream(MappingXsdSupport.jpa21);
            }
            if (MappingXsdSupport.jpa30.getNamespaceUri().matches(namespace)) {
                return this.openUrlStream(MappingXsdSupport.jpa30);
            }
            if (MappingXsdSupport.jpa31.getNamespaceUri().matches(namespace)) {
                return this.openUrlStream(MappingXsdSupport.jpa31);
            }
            if (ConfigXsdSupport.getJPA10().getNamespaceUri().matches(namespace)) {
                return this.openUrlStream(ConfigXsdSupport.getJPA10());
            }
            if (ConfigXsdSupport.getJPA21().getNamespaceUri().matches(namespace)) {
                return this.openUrlStream(ConfigXsdSupport.getJPA21());
            }
            if (ConfigXsdSupport.getJPA30().getNamespaceUri().matches(namespace)) {
                return this.openUrlStream(ConfigXsdSupport.getJPA30());
            }
            if (ConfigXsdSupport.getJPA31().getNamespaceUri().matches(namespace)) {
                return this.openUrlStream(ConfigXsdSupport.getJPA31());
            }
            if (MappingXsdSupport.hibernateMappingXml.getNamespaceUri().matches(namespace)) {
                return this.openUrlStream(MappingXsdSupport.hibernateMappingXml);
            }
            if (MappingXsdSupport.hbmXml.getNamespaceUri().matches(namespace)) {
                return this.openUrlStream(MappingXsdSupport.hbmXml);
            }
            if (ConfigXsdSupport.cfgXsd().getNamespaceUri().matches(namespace)) {
                return this.openUrlStream(ConfigXsdSupport.cfgXsd());
            }
        }
        if (publicID != null || systemID != null) {
            log.debugf("Checking public/system identifiers `%s`/`%s` as DTD references", (Object)publicID, (Object)systemID);
            if (MAPPING_DTD.matches(publicID, systemID)) {
                return this.openUrlStream(LocalXmlResourceResolver.MAPPING_DTD.localSchemaUrl);
            }
            if (ALTERNATE_MAPPING_DTD.matches(publicID, systemID)) {
                return this.openUrlStream(LocalXmlResourceResolver.ALTERNATE_MAPPING_DTD.localSchemaUrl);
            }
            if (LEGACY_MAPPING_DTD.matches(publicID, systemID)) {
                DeprecationLogger.DEPRECATION_LOGGER.recognizedObsoleteHibernateNamespace(LEGACY_MAPPING_DTD.getIdentifierBase(), MAPPING_DTD.getIdentifierBase());
                return this.openUrlStream(LocalXmlResourceResolver.MAPPING_DTD.localSchemaUrl);
            }
            if (CFG_DTD.matches(publicID, systemID)) {
                return this.openUrlStream(LocalXmlResourceResolver.CFG_DTD.localSchemaUrl);
            }
            if (ALTERNATE_CFG_DTD.matches(publicID, systemID)) {
                return this.openUrlStream(LocalXmlResourceResolver.ALTERNATE_CFG_DTD.localSchemaUrl);
            }
            if (LEGACY_CFG_DTD.matches(publicID, systemID)) {
                DeprecationLogger.DEPRECATION_LOGGER.recognizedObsoleteHibernateNamespace(LEGACY_CFG_DTD.getIdentifierBase(), CFG_DTD.getIdentifierBase());
                return this.openUrlStream(LocalXmlResourceResolver.CFG_DTD.localSchemaUrl);
            }
        }
        if (systemID != null && systemID.startsWith(CLASSPATH_EXTENSION_URL_BASE)) {
            log.debugf("Recognized `classpath:` identifier; attempting to resolve on classpath [%s]", (Object)systemID);
            String path = systemID.substring(CLASSPATH_EXTENSION_URL_BASE.length());
            InputStream stream = this.resolveInLocalNamespace(path);
            if (stream == null) {
                log.debugf("Unable to resolve [%s] on classpath", (Object)systemID);
            } else {
                log.debugf("Resolved [%s] on classpath", (Object)systemID);
            }
            return stream;
        }
        return null;
    }

    private InputStream openUrlStream(XsdDescriptor xsdDescriptor) {
        return this.openUrlStream(LocalSchemaLocator.resolveLocalSchemaUrl(xsdDescriptor.getLocalResourceName()));
    }

    private InputStream openUrlStream(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new XmlInfrastructureException("Could not open url stream : " + url.toExternalForm(), e);
        }
    }

    private InputStream resolveInLocalNamespace(String path) {
        try {
            return this.resourceStreamLocator.locateResourceStream(path);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static class DtdDescriptor {
        private final String httpBase;
        private final String httpsBase;
        private final URL localSchemaUrl;

        public DtdDescriptor(String identifierBase, String resourceName) {
            this.httpBase = "http://" + identifierBase;
            this.httpsBase = "https://" + identifierBase;
            this.localSchemaUrl = LocalSchemaLocator.resolveLocalSchemaUrl(resourceName);
        }

        public String getIdentifierBase() {
            return this.httpBase;
        }

        public boolean matches(String publicId, String systemId) {
            if (publicId != null && (publicId.startsWith(this.httpBase) || publicId.matches(this.httpsBase))) {
                return true;
            }
            return systemId != null && (systemId.startsWith(this.httpBase) || systemId.matches(this.httpsBase));
        }

        public URL getMappedLocalUrl() {
            return this.localSchemaUrl;
        }
    }
}

