/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MySQLServerConfiguration {
    private final int bytesPerCharacter;
    private final boolean noBackslashEscapesEnabled;

    public MySQLServerConfiguration(int bytesPerCharacter, boolean noBackslashEscapesEnabled) {
        this.bytesPerCharacter = bytesPerCharacter;
        this.noBackslashEscapesEnabled = noBackslashEscapesEnabled;
    }

    public int getBytesPerCharacter() {
        return this.bytesPerCharacter;
    }

    public boolean isNoBackslashEscapesEnabled() {
        return this.noBackslashEscapesEnabled;
    }

    public static MySQLServerConfiguration fromDatabaseMetadata(DatabaseMetaData databaseMetaData) {
        int bytesPerCharacter = 4;
        boolean noBackslashEscapes = false;
        if (databaseMetaData != null) {
            try (Statement s = databaseMetaData.getConnection().createStatement();){
                ResultSet rs = s.executeQuery("SELECT @@character_set_database, @@sql_mode");
                if (rs.next()) {
                    String characterSet = rs.getString(1);
                    int collationIndex = characterSet.indexOf(95);
                    switch (collationIndex == -1 ? characterSet : characterSet.substring(0, collationIndex)) {
                        case "utf16": 
                        case "utf16le": 
                        case "utf32": 
                        case "utf8mb4": 
                        case "gb18030": {
                            break;
                        }
                        case "utf8": 
                        case "utf8mb3": 
                        case "eucjpms": 
                        case "ujis": {
                            bytesPerCharacter = 3;
                            break;
                        }
                        case "ucs2": 
                        case "cp932": 
                        case "big5": 
                        case "euckr": 
                        case "gb2312": 
                        case "gbk": 
                        case "sjis": {
                            bytesPerCharacter = 2;
                            break;
                        }
                        default: {
                            bytesPerCharacter = 1;
                        }
                    }
                    String sqlMode = rs.getString(2);
                    if (sqlMode.toLowerCase().contains("no_backslash_escapes")) {
                        noBackslashEscapes = true;
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return new MySQLServerConfiguration(bytesPerCharacter, noBackslashEscapes);
    }
}

