/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.security;

import javax.naming.InvalidNameException;
import org.wildfly.naming.client.SimpleName;
import org.wildfly.naming.security.SimpleNamePermissions;
import org.wildfly.security.permission.AbstractNamedPermission;

public abstract class AbstractSimpleNamePermission<This extends AbstractSimpleNamePermission<This>>
extends AbstractNamedPermission<This> {
    private static final long serialVersionUID = -1008993794534492843L;
    private final transient SimpleName simpleName;

    protected AbstractSimpleNamePermission(String name) {
        super(name);
        try {
            this.simpleName = new SimpleName(name);
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected AbstractSimpleNamePermission(SimpleName simpleName) {
        super(simpleName.toString());
        this.simpleName = simpleName;
    }

    @Override
    public boolean impliesName(This permission) {
        return permission != null && this.impliesName(((AbstractSimpleNamePermission)permission).getSimpleName());
    }

    @Override
    public boolean impliesName(String name) {
        try {
            return this.impliesName(new SimpleName(name));
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    @Override
    public boolean impliesName(SimpleName otherName) {
        return SimpleNamePermissions.impliesName(this.simpleName, otherName);
    }

    @Override
    public boolean nameEquals(String name) {
        try {
            return this.nameEquals(new SimpleName(name));
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    @Override
    public boolean nameEquals(SimpleName name) {
        return this.simpleName.equals(name);
    }

    protected SimpleName getSimpleName() {
        return this.simpleName;
    }
}

