/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.behavior.AjaxBehavior;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.html.HtmlCommandScript;
import jakarta.faces.component.search.ComponentNotFoundException;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchExpressionHandler;
import jakarta.faces.component.search.SearchExpressionHint;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.render.ClientBehaviorRenderer;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    protected static final Logger logger = FacesLogger.RENDERKIT.getLogger();
    private static final Set<SearchExpressionHint> EXPRESSION_HINTS = EnumSet.of(SearchExpressionHint.RESOLVE_CLIENT_SIDE, SearchExpressionHint.RESOLVE_SINGLE_COMPONENT);

    @Override
    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        if (!(behavior instanceof AjaxBehavior)) {
            throw new IllegalArgumentException("Instance of jakarta.faces.component.behavior.AjaxBehavior required: " + behavior);
        }
        if (((AjaxBehavior)behavior).isDisabled()) {
            return null;
        }
        return AjaxBehaviorRenderer.buildAjaxCommand(behaviorContext, (AjaxBehavior)behavior);
    }

    @Override
    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        if (null == context || null == component || null == behavior) {
            throw new NullPointerException();
        }
        if (!(behavior instanceof AjaxBehavior)) {
            throw new IllegalArgumentException("Instance of jakarta.faces.component.behavior.AjaxBehavior required: " + behavior);
        }
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled()) {
            return;
        }
        component.queueEvent(AjaxBehaviorRenderer.createEvent(context, component, ajaxBehavior));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("This command resulted in form submission  AjaxBehaviorEvent queued.");
            logger.log(Level.FINE, "End decoding component {0}", component.getId());
        }
    }

    private static AjaxBehaviorEvent createEvent(FacesContext facesContext, UIComponent component, AjaxBehavior ajaxBehavior) {
        AjaxBehaviorEvent event = new AjaxBehaviorEvent(facesContext, component, ajaxBehavior);
        PhaseId phaseId = AjaxBehaviorRenderer.isImmediate(component, ajaxBehavior) ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION;
        event.setPhaseId(phaseId);
        return event;
    }

    private static boolean isImmediate(UIComponent component, AjaxBehavior ajaxBehavior) {
        boolean immediate = false;
        if (ajaxBehavior.isImmediateSet()) {
            immediate = ajaxBehavior.isImmediate();
        } else if (component instanceof EditableValueHolder) {
            immediate = ((EditableValueHolder)((Object)component)).isImmediate();
        } else if (component instanceof ActionSource) {
            immediate = ((ActionSource)((Object)component)).isImmediate();
        }
        return immediate;
    }

    private static String buildAjaxCommand(ClientBehaviorContext behaviorContext, AjaxBehavior ajaxBehavior) {
        HtmlCommandScript commandScript;
        Collection<ClientBehaviorContext.Parameter> params;
        Boolean resetValues;
        String delay;
        String sourceId;
        String onerror;
        String onevent;
        Collection<String> render;
        Collection<String> execute;
        StringBuilder ajaxCommand;
        String eventName;
        UIComponent component;
        block25: {
            if (ajaxBehavior.isDisabled()) {
                return null;
            }
            component = behaviorContext.getComponent();
            eventName = behaviorContext.getEventName();
            ajaxCommand = new StringBuilder(256);
            execute = ajaxBehavior.getExecute();
            render = ajaxBehavior.getRender();
            onevent = ajaxBehavior.getOnevent();
            onerror = ajaxBehavior.getOnerror();
            sourceId = behaviorContext.getSourceId();
            delay = ajaxBehavior.getDelay();
            resetValues = null;
            if (ajaxBehavior.isResetValuesSet()) {
                resetValues = ajaxBehavior.isResetValues();
            }
            params = behaviorContext.getParameters();
            ClientBehaviorContext.Parameter foundparam = null;
            for (ClientBehaviorContext.Parameter param : params) {
                if (!param.getName().equals("incExec") || !((Boolean)param.getValue()).booleanValue()) continue;
                foundparam = param;
            }
            if (foundparam != null && !execute.contains(sourceId)) {
                execute = new LinkedList<String>(execute);
                execute.add(component.getClientId());
            }
            if (foundparam != null) {
                try {
                    params.remove(foundparam);
                }
                catch (UnsupportedOperationException uoe) {
                    if (!logger.isLoggable(Level.FINEST)) break block25;
                    logger.log(Level.FINEST, "Unsupported operation", uoe);
                }
            }
        }
        HtmlCommandScript htmlCommandScript = commandScript = component instanceof HtmlCommandScript ? (HtmlCommandScript)component : null;
        if (commandScript != null) {
            String name = commandScript.getName();
            if (!name.contains(".")) {
                ajaxCommand.append("var ");
            }
            ajaxCommand.append(name).append('=').append("function(o){var o=(typeof o==='object')&&o?o:{};");
            for (ClientBehaviorContext.Parameter param : params) {
                ajaxCommand.append("o[");
                RenderKitUtils.appendQuotedValue(ajaxCommand, param.getName());
                ajaxCommand.append("]=");
                Object paramValue = param.getValue();
                if (paramValue == null) {
                    ajaxCommand.append("null");
                } else {
                    RenderKitUtils.appendQuotedValue(ajaxCommand, paramValue.toString());
                }
                ajaxCommand.append(";");
            }
            params = Collections.singleton(new ClientBehaviorContext.Parameter("o", null));
        }
        ajaxCommand.append("mojarra.ab(");
        if (sourceId == null) {
            ajaxCommand.append("this");
        } else {
            ajaxCommand.append("'");
            ajaxCommand.append(sourceId);
            ajaxCommand.append("'");
        }
        ajaxCommand.append(",");
        ajaxCommand.append(commandScript == null ? "event" : "null");
        ajaxCommand.append(",'");
        ajaxCommand.append(eventName);
        ajaxCommand.append("',");
        AjaxBehaviorRenderer.appendIds(behaviorContext.getFacesContext(), component, ajaxCommand, execute);
        ajaxCommand.append(",");
        AjaxBehaviorRenderer.appendIds(behaviorContext.getFacesContext(), component, ajaxCommand, render);
        if (onevent != null || onerror != null || delay != null || resetValues != null || !params.isEmpty()) {
            ajaxCommand.append(",{");
            if (onevent != null) {
                RenderKitUtils.appendProperty(ajaxCommand, "onevent", onevent, false);
            }
            if (onerror != null) {
                RenderKitUtils.appendProperty(ajaxCommand, "onerror", onerror, false);
            }
            if (delay != null) {
                RenderKitUtils.appendProperty(ajaxCommand, "delay", delay, true);
            }
            if (resetValues != null) {
                RenderKitUtils.appendProperty(ajaxCommand, "resetValues", resetValues, false);
            }
            if (!params.isEmpty()) {
                if (commandScript != null) {
                    RenderKitUtils.appendProperty(ajaxCommand, "params", params.iterator().next().getName(), false);
                } else {
                    RenderKitUtils.appendProperty(ajaxCommand, "params", "{", false);
                    for (ClientBehaviorContext.Parameter param : params) {
                        RenderKitUtils.appendProperty(ajaxCommand, param.getName(), param.getValue());
                    }
                    ajaxCommand.append("}");
                }
            }
            ajaxCommand.append("}");
        }
        ajaxCommand.append(")");
        if (commandScript != null) {
            ajaxCommand.append("}");
            if (commandScript.isAutorun()) {
                ajaxCommand.append(";mojarra.l(").append(commandScript.getName()).append(")");
            }
        }
        return ajaxCommand.toString();
    }

    private static void appendIds(FacesContext facesContext, UIComponent component, StringBuilder builder, Collection<String> ids) {
        if (null == ids || ids.isEmpty()) {
            builder.append('0');
            return;
        }
        builder.append("'");
        SearchExpressionHandler handler = null;
        SearchExpressionContext searchExpressionContext = null;
        boolean first = true;
        UIComponent composite = UIComponent.getCompositeComponentParent(component);
        String separatorChar = String.valueOf(UINamingContainer.getSeparatorChar(facesContext));
        for (String id : ids) {
            boolean clientResolveableExpression;
            Object expression = id.trim();
            if (((String)expression).length() == 0) continue;
            if (!first) {
                builder.append(' ');
            } else {
                first = false;
            }
            boolean bl = clientResolveableExpression = ((String)expression).equals("@all") || ((String)expression).equals("@none") || ((String)expression).equals("@form") || ((String)expression).equals("@this");
            if (composite != null && !AjaxBehaviorRenderer.isHandledByInsertChildren(component, composite) && (((String)expression).equals("@this") || ((String)expression).startsWith("@this" + separatorChar))) {
                expression = ((String)expression).replaceFirst("@this", separatorChar + composite.getClientId(facesContext));
                clientResolveableExpression = false;
            }
            if (clientResolveableExpression) {
                builder.append((String)expression);
                continue;
            }
            if (searchExpressionContext == null) {
                searchExpressionContext = SearchExpressionContext.createSearchExpressionContext(facesContext, component, EXPRESSION_HINTS, null);
            }
            if (handler == null) {
                handler = facesContext.getApplication().getSearchExpressionHandler();
            }
            String resolvedClientId = null;
            try {
                resolvedClientId = handler.resolveClientId(searchExpressionContext, (String)expression);
            }
            catch (ComponentNotFoundException cnfe) {
                if (composite != null && !((String)expression).startsWith(separatorChar) && composite.getParent() != null && composite.getParent().getNamingContainer() != null) {
                    expression = composite.getParent().getNamingContainer().getClientId(facesContext) + separatorChar + (String)expression;
                    try {
                        resolvedClientId = handler.resolveClientId(searchExpressionContext, (String)expression);
                    }
                    catch (ComponentNotFoundException ignore) {
                        resolvedClientId = AjaxBehaviorRenderer.getResolvedId(component, (String)expression);
                    }
                }
                resolvedClientId = AjaxBehaviorRenderer.getResolvedId(component, (String)expression);
            }
            builder.append(resolvedClientId);
        }
        builder.append("'");
    }

    private static boolean isHandledByInsertChildren(UIComponent component, UIComponent composite) {
        for (UIComponent parent = component.getParent(); parent != null && !parent.equals(composite); parent = parent.getParent()) {
            if (!parent.getAttributes().containsKey("InsertChildrenHandler.idx")) continue;
            return true;
        }
        return false;
    }

    private static String getResolvedId(UIComponent component, String id) {
        UIComponent resolvedComponent = component.findComponent(id);
        if (resolvedComponent == null) {
            if (id.charAt(0) == UINamingContainer.getSeparatorChar(FacesContext.getCurrentInstance())) {
                return id.substring(1);
            }
            return id;
        }
        return resolvedComponent.getClientId();
    }
}

