/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.broadcast;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.server.service.ClusteringRequirement;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.broadcast.ConcurrentBroadcastCommandDispatcherFactory;

public class BroadcastCommandDispatcherFactoryInstaller
implements BiConsumer<OperationContext, String> {
    private final Set<ServiceName> names = Collections.synchronizedSet(new TreeSet());

    @Override
    public void accept(OperationContext context, String channelName) {
        ServiceName name = MessagingServices.getBroadcastCommandDispatcherFactoryServiceName(channelName);
        if (this.names.add(name)) {
            ServiceBuilder builder = context.getServiceTarget().addService(name);
            Consumer injector = builder.provides(new ServiceName[]{name});
            Supplier factory = builder.requires(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(context, channelName));
            FunctionalService service = new FunctionalService(injector, ConcurrentBroadcastCommandDispatcherFactory::new, factory);
            builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
    }
}

