/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import org.jboss.as.clustering.controller.ManagementRegistrar;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.jgroups.subsystem.MulticastTransportConfigurationServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.SocketTransportConfigurationServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.SocketTransportResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;

public class TransportResourceRegistrar
implements ManagementRegistrar<ManagementResourceRegistration> {
    private final ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory;

    public TransportResourceRegistrar(ResourceServiceConfiguratorFactory parentServiceConfiguratorFactory) {
        this.parentServiceConfiguratorFactory = parentServiceConfiguratorFactory;
    }

    public void register(ManagementResourceRegistration registration) {
        new TransportResourceDefinition(this.parentServiceConfiguratorFactory).register(registration);
        for (MulticastTransport multicastTransport : EnumSet.allOf(MulticastTransport.class)) {
            new TransportResourceDefinition(multicastTransport.name(), MulticastTransportConfigurationServiceConfigurator::new, this.parentServiceConfiguratorFactory).register(registration);
        }
        for (SocketTransport socketTransport : EnumSet.allOf(SocketTransport.class)) {
            new SocketTransportResourceDefinition(socketTransport.name(), SocketTransportConfigurationServiceConfigurator::new, this.parentServiceConfiguratorFactory).register(registration);
        }
    }

    static enum SocketTransport {
        TCP,
        TCP_NIO2;

    }

    static enum MulticastTransport {
        UDP;

    }
}

