/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import jakarta.security.jacc.PolicyContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public class PolicyContextIdInterceptor
implements Interceptor {
    private final String policyContextID;

    public PolicyContextIdInterceptor(String policyContextID) {
        this.policyContextID = policyContextID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        String oldId = PolicyContext.getContextID();
        PolicyContextIdInterceptor.setContextID(this.policyContextID);
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            PolicyContextIdInterceptor.setContextID(oldId);
        }
    }

    private static void setContextID(String contextID) {
        WildFlySecurityManager.doPrivilegedWithParameter((Object)contextID, PolicyContextIdInterceptor::doSetContextID);
    }

    private static Void doSetContextID(String policyContextID) {
        PolicyContext.setContextID((String)policyContextID);
        return null;
    }
}

