/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.tagext.TagInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.jasper.JasperException;
import org.apache.jasper.JasperLogger;
import org.apache.jasper.JasperMessages;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.runtime.InstanceManagerFactory;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.util.ExceptionUtils;
import org.apache.jasper.util.FastRemovalDequeue;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.scan.Jar;

public class JspServletWrapper {
    private static final Map<String, Long> ALWAYS_OUTDATED_DEPENDENCIES = new HashMap<String, Long>();
    private Servlet theServlet;
    private final String jspUri;
    private Class<?> tagHandlerClass;
    private final JspCompilationContext ctxt;
    private long available = 0L;
    private final ServletConfig config;
    private final Options options;
    private boolean firstTime = true;
    private volatile boolean reload = true;
    private final boolean isTagFile;
    private int tripCount;
    private JasperException compileException;
    private volatile long servletClassLastModifiedTime;
    private long lastModificationTest = 0L;
    private long lastUsageTime = System.currentTimeMillis();
    private FastRemovalDequeue.Entry unloadHandle;
    private final boolean unloadAllowed;
    private final boolean unloadByCount;
    private final boolean unloadByIdle;

    public JspServletWrapper(ServletConfig config, Options options, String jspUri, JspRuntimeContext rctxt) {
        this.isTagFile = false;
        this.config = config;
        this.options = options;
        this.jspUri = jspUri;
        this.unloadByCount = options.getMaxLoadedJsps() > 0;
        this.unloadByIdle = options.getJspIdleTimeout() > 0;
        this.unloadAllowed = this.unloadByCount || this.unloadByIdle;
        this.ctxt = new JspCompilationContext(jspUri, options, config.getServletContext(), this, rctxt);
    }

    public JspServletWrapper(ServletContext servletContext, Options options, String tagFilePath, TagInfo tagInfo, JspRuntimeContext rctxt, Jar tagJar) {
        this.isTagFile = true;
        this.config = null;
        this.options = options;
        this.jspUri = tagFilePath;
        this.tripCount = 0;
        this.unloadByCount = options.getMaxLoadedJsps() > 0;
        this.unloadByIdle = options.getJspIdleTimeout() > 0;
        this.unloadAllowed = this.unloadByCount || this.unloadByIdle;
        this.ctxt = new JspCompilationContext(this.jspUri, tagInfo, options, servletContext, this, rctxt, tagJar);
    }

    public JspCompilationContext getJspEngineContext() {
        return this.ctxt;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet getServlet() throws ServletException {
        if (this.reload) {
            JspServletWrapper jspServletWrapper = this;
            synchronized (jspServletWrapper) {
                if (this.reload) {
                    Servlet servlet;
                    this.destroy();
                    try {
                        InstanceManager instanceManager = InstanceManagerFactory.getInstanceManager(this.config);
                        servlet = (Servlet)instanceManager.newInstance(this.ctxt.getFQCN(), this.ctxt.getJspLoader());
                    }
                    catch (Exception e) {
                        Throwable t = ExceptionUtils.unwrapInvocationTargetException(e);
                        ExceptionUtils.handleThrowable(t);
                        throw new JasperException(t);
                    }
                    servlet.init(this.config);
                    if (!this.firstTime) {
                        this.ctxt.getRuntimeContext().incrementJspReloadCount();
                    }
                    this.theServlet = servlet;
                    this.reload = false;
                }
            }
        }
        return this.theServlet;
    }

    public ServletContext getServletContext() {
        return this.ctxt.getServletContext();
    }

    public void setCompilationException(JasperException je) {
        this.compileException = je;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServletClassLastModifiedTime(long lastModified) {
        if (this.servletClassLastModifiedTime < lastModified) {
            JspServletWrapper jspServletWrapper = this;
            synchronized (jspServletWrapper) {
                if (this.servletClassLastModifiedTime < lastModified) {
                    this.servletClassLastModifiedTime = lastModified;
                    this.reload = true;
                    this.ctxt.clearJspLoader();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadTagFile() throws JasperException {
        try {
            if (this.ctxt.isRemoved()) {
                throw new FileNotFoundException(this.jspUri);
            }
            if (this.options.getDevelopment() || this.firstTime) {
                JspServletWrapper jspServletWrapper = this;
                synchronized (jspServletWrapper) {
                    this.firstTime = false;
                    this.ctxt.compile();
                }
            } else if (this.compileException != null) {
                throw this.compileException;
            }
            if (this.reload) {
                this.tagHandlerClass = this.ctxt.load();
                this.reload = false;
            }
        }
        catch (FileNotFoundException ex) {
            throw new JasperException(ex);
        }
        return this.tagHandlerClass;
    }

    public Class<?> loadTagFilePrototype() throws JasperException {
        this.ctxt.setPrototypeMode(true);
        try {
            Class<?> clazz = this.loadTagFile();
            return clazz;
        }
        finally {
            this.ctxt.setPrototypeMode(false);
        }
    }

    public Map<String, Long> getDependants() {
        try {
            Object target;
            if (this.isTagFile) {
                if (this.reload) {
                    this.tagHandlerClass = this.ctxt.load();
                    this.reload = false;
                }
                target = this.tagHandlerClass.newInstance();
            } else {
                target = this.getServlet();
            }
            if (target instanceof JspSourceDependent) {
                return ((JspSourceDependent)target).getDependants();
            }
        }
        catch (AbstractMethodError ame) {
            return ALWAYS_OUTDATED_DEPENDENCIES;
        }
        catch (Throwable ex) {
            ExceptionUtils.handleThrowable(ex);
        }
        return null;
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public int incTripCount() {
        return this.tripCount++;
    }

    public int decTripCount() {
        return this.tripCount--;
    }

    public String getJspUri() {
        return this.jspUri;
    }

    public FastRemovalDequeue.Entry getUnloadHandle() {
        return this.unloadHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response, boolean precompile) throws ServletException, IOException, FileNotFoundException {
        Servlet servlet;
        try {
            if (this.ctxt.isRemoved()) {
                throw new FileNotFoundException(this.jspUri);
            }
            if (this.available > 0L && this.available < Long.MAX_VALUE) {
                if (this.available > System.currentTimeMillis()) {
                    response.setDateHeader("Retry-After", this.available);
                    response.sendError(503, JasperMessages.MESSAGES.unavailable());
                    return;
                }
                this.available = 0L;
            }
            if (this.options.getDevelopment() || this.firstTime) {
                JspServletWrapper jspServletWrapper = this;
                synchronized (jspServletWrapper) {
                    this.firstTime = false;
                    this.ctxt.compile();
                }
            } else if (this.compileException != null) {
                throw this.compileException;
            }
            servlet = this.getServlet();
            if (precompile) {
                return;
            }
        }
        catch (ServletException ex) {
            if (this.options.getDevelopment()) {
                throw this.handleJspException((Exception)((Object)ex));
            }
            throw ex;
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ex) {
            if (this.options.getDevelopment()) {
                throw this.handleJspException(ex);
            }
            throw ex;
        }
        catch (IllegalStateException ex) {
            if (this.options.getDevelopment()) {
                throw this.handleJspException(ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (this.options.getDevelopment()) {
                throw this.handleJspException(ex);
            }
            throw new JasperException(ex);
        }
        try {
            if (this.unloadAllowed) {
                JspServletWrapper ex = this;
                synchronized (ex) {
                    if (this.unloadByCount) {
                        if (this.unloadHandle == null) {
                            this.unloadHandle = this.ctxt.getRuntimeContext().push(this);
                        } else if (this.lastUsageTime < this.ctxt.getRuntimeContext().getLastJspQueueUpdate()) {
                            this.ctxt.getRuntimeContext().makeYoungest(this.unloadHandle);
                            this.lastUsageTime = System.currentTimeMillis();
                        }
                    } else if (this.lastUsageTime < this.ctxt.getRuntimeContext().getLastJspQueueUpdate()) {
                        this.lastUsageTime = System.currentTimeMillis();
                    }
                }
            }
            servlet.service((ServletRequest)request, (ServletResponse)response);
        }
        catch (UnavailableException ex) {
            String includeRequestUri = (String)request.getAttribute("jakarta.servlet.include.request_uri");
            if (includeRequestUri != null) {
                throw ex;
            }
            int unavailableSeconds = ex.getUnavailableSeconds();
            if (unavailableSeconds <= 0) {
                unavailableSeconds = 60;
            }
            this.available = System.currentTimeMillis() + (long)unavailableSeconds * 1000L;
            response.sendError(503, ex.getMessage());
        }
        catch (ServletException ex) {
            if (this.options.getDevelopment()) {
                throw this.handleJspException((Exception)((Object)ex));
            }
            throw ex;
        }
        catch (IOException ex) {
            if (this.options.getDevelopment()) {
                throw new IOException(this.handleJspException(ex).getMessage(), ex);
            }
            throw ex;
        }
        catch (IllegalStateException ex) {
            if (this.options.getDevelopment()) {
                throw this.handleJspException(ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (this.options.getDevelopment()) {
                throw this.handleJspException(ex);
            }
            throw new JasperException(ex);
        }
    }

    public void destroy() {
        if (this.theServlet != null) {
            this.theServlet.destroy();
            InstanceManager instanceManager = InstanceManagerFactory.getInstanceManager(this.config);
            try {
                instanceManager.destroyInstance(this.theServlet);
            }
            catch (Exception e) {
                Throwable t = ExceptionUtils.unwrapInvocationTargetException(e);
                ExceptionUtils.handleThrowable(t);
                JasperLogger.SERVLET_LOGGER.errorDestroyingServletInstance(e);
            }
        }
    }

    public long getLastModificationTest() {
        return this.lastModificationTest;
    }

    public void setLastModificationTest(long lastModificationTest) {
        this.lastModificationTest = lastModificationTest;
    }

    public long getLastUsageTime() {
        return this.lastUsageTime;
    }

    protected JasperException handleJspException(Exception ex) {
        try {
            Throwable realException = ex;
            if (ex instanceof ServletException) {
                realException = ((ServletException)((Object)ex)).getRootCause();
            }
            StackTraceElement[] frames = realException != null ? realException.getStackTrace() : new StackTraceElement[]{};
            StackTraceElement jspFrame = null;
            for (int i = 0; i < frames.length; ++i) {
                if (!frames[i].getClassName().equals(this.getServlet().getClass().getName())) continue;
                jspFrame = frames[i];
                break;
            }
            if (jspFrame == null || this.ctxt.getCompiler().getPageNodes() == null) {
                return new JasperException(ex);
            }
            int javaLineNumber = jspFrame.getLineNumber();
            JavacErrorDetail detail = ErrorDispatcher.createJavacError(jspFrame.getMethodName(), this.ctxt.getCompiler().getPageNodes(), null, javaLineNumber, this.ctxt);
            int jspLineNumber = detail.getJspBeginLineNumber();
            if (jspLineNumber < 1) {
                throw new JasperException(ex);
            }
            if (this.options.getDisplaySourceFragment()) {
                return new JasperException(JasperMessages.MESSAGES.jspExceptionWithDetails(detail.getJspFileName(), jspLineNumber, jspLineNumber + System.lineSeparator() + System.lineSeparator() + detail.getJspExtract() + System.lineSeparator() + System.lineSeparator()), ex);
            }
            return new JasperException(JasperMessages.MESSAGES.jspException(detail.getJspFileName(), jspLineNumber), ex);
        }
        catch (Exception je) {
            if (ex instanceof JasperException) {
                return (JasperException)((Object)ex);
            }
            return new JasperException(ex);
        }
    }

    public void jspFileChanged() {
        this.firstTime = true;
        this.reload = true;
    }

    static {
        ALWAYS_OUTDATED_DEPENDENCIES.put("/WEB-INF/web.xml", -1L);
    }
}

