/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;

public class EntitiesDescriptorImpl
extends AbstractSignableSAMLObject
implements EntitiesDescriptor {
    private String name;
    private String id;
    private Instant validUntil;
    private Duration cacheDuration;
    private Extensions extensions;
    private final IndexedXMLObjectChildrenList<SAMLObject> orderedDescriptors = new IndexedXMLObjectChildrenList((XMLObject)this);

    protected EntitiesDescriptorImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = this.prepareForAssignment(this.name, newName);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    public boolean isValid() {
        if (null == this.validUntil) {
            return true;
        }
        return Instant.now().isBefore(this.validUntil);
    }

    public Instant getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(Instant newValidUntil) {
        this.validUntil = (Instant)this.prepareForAssignment(this.validUntil, newValidUntil);
    }

    public Duration getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(Duration duration) {
        this.cacheDuration = (Duration)this.prepareForAssignment(this.cacheDuration, duration);
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Extensions newExtensions) {
        this.extensions = (Extensions)this.prepareForAssignment((XMLObject)this.extensions, (XMLObject)newExtensions);
    }

    public List<EntitiesDescriptor> getEntitiesDescriptors() {
        return this.orderedDescriptors.subList(EntitiesDescriptor.ELEMENT_QNAME);
    }

    public List<EntityDescriptor> getEntityDescriptors() {
        return this.orderedDescriptors.subList(EntityDescriptor.ELEMENT_QNAME);
    }

    public String getSignatureReferenceID() {
        return this.id;
    }

    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.getSignature() != null) {
            children.add(this.getSignature());
        }
        children.add(this.getExtensions());
        children.addAll((Collection<Object>)this.orderedDescriptors);
        return Collections.unmodifiableList(children);
    }
}

