|Attribute (_alias_) | Description | Type   | Mandatory | Default |
| :---               | :----       | :----: | :----:    | :---    |
| *auto.offset.reset* | What to do when there is no initial offset in Kafka.Accepted values are earliest, latest and none | string | false | `latest` |
| *batch* | Whether the Kafka records are consumed in batch. The channel injection point must consume a compatible type, such as `List<Payload>` or `KafkaRecordBatch<Payload>`. | boolean | false | `false` |
| *bootstrap.servers* _(kafka.bootstrap.servers)_ | A comma-separated list of host:port to use for establishing the initial connection to the Kafka cluster. | string | false | `localhost:9092` |
| *broadcast* | Whether the Kafka records should be dispatched to multiple consumer | boolean | false | `false` |
| *checkpoint.state-store* | While using the `checkpoint` commit-strategy, the name set in `@Identifier` of a bean that implements `io.smallrye.reactive.messaging.kafka.StateStore.Factory` to specify the state store implementation. | string | false |  |
| *checkpoint.state-type* | While using the `checkpoint` commit-strategy, the fully qualified type name of the state object to persist in the state store. When provided, it can be used by the state store implementation to help persisting the processing state object. | string | false |  |
| *checkpoint.unsynced-state-max-age.ms* | While using the `checkpoint` commit-strategy, specify the max age in milliseconds that the processing state must be persisted before the connector is marked as unhealthy. Setting this attribute to 0 disables this monitoring. | int | false | `10000` |
| *client-id-prefix* | Prefix for Kafka client `client.id` attribute. If defined configured or generated `client.id` will be prefixed with the given value. | string | false |  |
| *cloud-events* | Enables (default) or disables the Cloud Event support. If enabled on an _incoming_ channel, the connector analyzes the incoming records and try to create Cloud Event metadata. If enabled on an _outgoing_, the connector sends the outgoing messages as Cloud Event if the message includes Cloud Event Metadata. | boolean | false | `true` |
| *commit-strategy* | Specify the commit strategy to apply when a message produced from a record is acknowledged. Values can be `latest`, `ignore` or `throttled`. If `enable.auto.commit` is true then the default is `ignore` otherwise it is `throttled` | string | false |  |
| *consumer-rebalance-listener.name* | The name set in `@Identifier` of a bean that implements `io.smallrye.reactive.messaging.kafka.KafkaConsumerRebalanceListener`. If set, this rebalance listener is applied to the consumer. | string | false |  |
| *dead-letter-queue.key.serializer* | When the `failure-strategy` is set to `dead-letter-queue` indicates the key serializer to use. If not set the serializer associated to the key deserializer is used | string | false |  |
| *dead-letter-queue.producer-client-id* | When the `failure-strategy` is set to `dead-letter-queue` indicates what client id the generated producer should use. Defaults is `kafka-dead-letter-topic-producer-$client-id` | string | false |  |
| *dead-letter-queue.topic* | When the `failure-strategy` is set to `dead-letter-queue` indicates on which topic the record is sent. Defaults is `dead-letter-topic-$channel` | string | false |  |
| *dead-letter-queue.value.serializer* | When the `failure-strategy` is set to `dead-letter-queue` indicates the value serializer to use. If not set the serializer associated to the value deserializer is used | string | false |  |
| *delayed-retry-topic.max-retries* | When the `failure-strategy` is set to `delayed-retry-topic` indicates the maximum number of retries. If higher than the number of delayed retry topics, last topic is used. | int | false |  |
| *delayed-retry-topic.timeout* | When the `failure-strategy` is set to `delayed-retry-topic` indicates the global timeout per record. | int | false | `120000` |
| *delayed-retry-topic.topics* | When the `failure-strategy` is set to `delayed-retry-topic` indicates topics to use. If not set the source channel name is used, with 10, 20 and 50 seconds delayed topics. | string | false |  |
| *enable.auto.commit* | If enabled, consumer's offset will be periodically committed in the background by the underlying Kafka client, ignoring the actual processing outcome of the records. It is recommended to NOT enable this setting and let Reactive Messaging handles the commit. | boolean | false | `false` |
| *fail-on-deserialization-failure* | When no deserialization failure handler is set and a deserialization failure happens, report the failure and mark the application as unhealthy. If set to `false` and a deserialization failure happens, a `null` value is forwarded. | boolean | false | `true` |
| *failure-strategy* | Specify the failure strategy to apply when a message produced from a record is acknowledged negatively (nack). Values can be `fail` (default), `ignore`, or `dead-letter-queue` | string | false | `fail` |
| *fetch.min.bytes* | The minimum amount of data the server should return for a fetch request. The default setting of 1 byte means that fetch requests are answered as soon as a single byte of data is available or the fetch request times out waiting for data to arrive. | int | false | `1` |
| *graceful-shutdown* | Whether or not a graceful shutdown should be attempted when the application terminates. | boolean | false | `true` |
| *group.id* | A unique string that identifies the consumer group the application belongs to. If not set, a unique, generated id is used | string | false |  |
| *health-enabled* | Whether health reporting is enabled (default) or disabled | boolean | false | `true` |
| *health-readiness-enabled* | Whether readiness health reporting is enabled (default) or disabled | boolean | false | `true` |
| *health-readiness-timeout* | _deprecated_ - During the readiness health check, the connector connects to the broker and retrieves the list of topics. This attribute specifies the maximum duration (in ms) for the retrieval. If exceeded, the channel is considered not-ready. Deprecated: Use 'health-topic-verification-timeout' instead. | long | false |  |
| *health-readiness-topic-verification* | _deprecated_ - Whether the readiness check should verify that topics exist on the broker. Default to false. Enabling it requires an admin connection. Deprecated: Use 'health-topic-verification-enabled' instead. | boolean | false |  |
| *health-topic-verification-enabled* | Whether the startup and readiness check should verify that topics exist on the broker. Default to false. Enabling it requires an admin client connection. | boolean | false | `false` |
| *health-topic-verification-readiness-disabled* | Whether the topic verification is disabled for the readiness health check. | boolean | false | `false` |
| *health-topic-verification-startup-disabled* | Whether the topic verification is disabled for the startup health check. | boolean | false | `false` |
| *health-topic-verification-timeout* | During the startup and readiness health check, the connector connects to the broker and retrieves the list of topics. This attribute specifies the maximum duration (in ms) for the retrieval. If exceeded, the channel is considered not-ready. | long | false | `2000` |
| *kafka-configuration* | Identifier of a CDI bean that provides the default Kafka consumer/producer configuration for this channel. The channel configuration can still override any attribute. The bean must have a type of Map<String, Object> and must use the @io.smallrye.common.annotation.Identifier qualifier to set the identifier. | string | false |  |
| *key-deserialization-failure-handler* | The name set in `@Identifier` of a bean that implements `io.smallrye.reactive.messaging.kafka.DeserializationFailureHandler`. If set, deserialization failure happening when deserializing keys are delegated to this handler which may retry or provide a fallback value. | string | false |  |
| *key.deserializer* | The deserializer classname used to deserialize the record's key | string | false | `org.apache.kafka.common.serialization.StringDeserializer` |
| *lazy-client* | Whether Kafka client is created lazily or eagerly. | boolean | false | `false` |
| *max-queue-size-factor* | Multiplier factor to determine maximum number of records queued for processing, using `max.poll.records` * `max-queue-size-factor`. Defaults to 2. In `batch` mode `max.poll.records` is considered `1`. | int | false | `2` |
| *partitions* | The number of partitions to be consumed concurrently. The connector creates the specified amount of Kafka consumers. It should match the number of partition of the targeted topic | int | false | `1` |
| *pattern* | Indicate that the `topic` property is a regular expression. Must be used with the `topic` property. Cannot be used with the `topics` property | boolean | false | `false` |
| *pause-if-no-requests* | Whether the polling must be paused when the application does not request items and resume when it does. This allows implementing back-pressure based on the application capacity. Note that polling is not stopped, but will not retrieve any records when paused. | boolean | false | `true` |
| *poll-timeout* | The polling timeout in milliseconds. When polling records, the poll will wait at most that duration before returning records. Default is 1000ms | int | false | `1000` |
| *requests* | When `partitions` is greater than 1, this attribute allows configuring how many records are requested by each consumers every time. | int | false | `128` |
| *retry* | Whether or not the connection to the broker is re-attempted in case of failure | boolean | false | `true` |
| *retry-attempts* | The maximum number of reconnection before failing. -1 means infinite retry | int | false | `-1` |
| *retry-max-wait* | The max delay (in seconds) between 2 reconnects | int | false | `30` |
| *throttled.unprocessed-record-max-age.ms* | While using the `throttled` commit-strategy, specify the max age in milliseconds that an unprocessed message can be before the connector is marked as unhealthy. Setting this attribute to 0 disables this monitoring. | int | false | `60000` |
| *topic* | The consumed / populated Kafka topic. If neither this property nor the `topics` properties are set, the channel name is used | string | false |  |
| *topics* | A comma-separating list of topics to be consumed. Cannot be used with the `topic` or `pattern` properties | string | false |  |
| *tracing-enabled* | Whether tracing is enabled (default) or disabled | boolean | false | `true` |
| *value-deserialization-failure-handler* | The name set in `@Identifier` of a bean that implements `io.smallrye.reactive.messaging.kafka.DeserializationFailureHandler`. If set, deserialization failure happening when deserializing values are delegated to this handler which may retry or provide a fallback value. | string | false |  |
| *value.deserializer* | The deserializer classname used to deserialize the record's value | string | true |  |
