/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.stat.Statistics;
import org.jboss.as.jpa.spi.PersistenceUnitService;
import org.jboss.as.jpa.spi.PersistenceUnitServiceRegistry;

public class ManagementLookup {
    private final Statistics stats;
    private final EntityManagerFactory entityManagerFactory;

    public ManagementLookup(Statistics stats, EntityManagerFactory entityManagerFactory) {
        this.stats = stats;
        this.entityManagerFactory = entityManagerFactory;
    }

    public static ManagementLookup create(PersistenceUnitServiceRegistry registry, String persistenceUnitName) {
        EntityManagerFactory entityManagerFactory;
        HibernateEntityManagerFactory entityManagerFactoryImpl;
        SessionFactory sessionFactory;
        Statistics stats = null;
        PersistenceUnitService persistenceUnitService = registry.getPersistenceUnitService(persistenceUnitName);
        if (persistenceUnitService != null && (sessionFactory = (entityManagerFactoryImpl = (HibernateEntityManagerFactory)(entityManagerFactory = persistenceUnitService.getEntityManagerFactory())).getSessionFactory()) != null) {
            stats = sessionFactory.getStatistics();
            return new ManagementLookup(stats, entityManagerFactory);
        }
        return null;
    }

    public Statistics getStatistics() {
        return this.stats;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }
}

