/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XWiringSupport;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.jboss.osgi.resolver.spi.AbstractWiringSupport;
import org.jboss.osgi.resolver.spi.ResourceValidationException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class AbstractResource
extends AbstractElement
implements XResource {
    private final Map<String, List<Capability>> capabilities = new HashMap<String, List<Capability>>();
    private final Map<String, List<Requirement>> requirements = new HashMap<String, List<Requirement>>();
    private final AtomicBoolean mutable = new AtomicBoolean(true);
    private final XWiringSupport wiringSupport;
    private XIdentityCapability identityCapability;
    private XResource.State state = XResource.State.UNINSTALLED;
    private int types;

    static AbstractResource assertAbstractResource(XResource resource) {
        assert (resource != null) : "Null resource";
        assert (resource instanceof AbstractResource) : "Not an AbstractResource: " + resource;
        return (AbstractResource)resource;
    }

    public AbstractResource() {
        this.wiringSupport = this.createWiringSupport();
    }

    XWiringSupport createWiringSupport() {
        return new AbstractWiringSupport();
    }

    protected void addCapability(Capability cap) {
        this.ensureMutable();
        String namespace = cap.getNamespace();
        this.getCaplist(namespace).add(cap);
        this.getCaplist(null).add(cap);
        if ("osgi.identity".equals(namespace)) {
            this.identityCapability = (XIdentityCapability)cap;
        }
    }

    protected void addRequirement(Requirement req) {
        this.ensureMutable();
        String namespace = req.getNamespace();
        this.getReqlist(namespace).add(req);
        this.getReqlist(null).add(req);
    }

    @Override
    public void setMutable(boolean flag) {
        this.mutable.set(flag);
    }

    @Override
    public XResource.State getState() {
        return this.state;
    }

    void setState(XResource.State state) {
        this.state = state;
    }

    @Override
    public boolean isMutable() {
        return this.mutable.get();
    }

    public void ensureImmutable() {
        if (this.isMutable()) {
            throw ResolverMessages.MESSAGES.illegalStateInvalidAccessToMutableResource();
        }
    }

    public void ensureMutable() {
        if (!this.isMutable()) {
            throw ResolverMessages.MESSAGES.illegalStateInvalidAccessToImmutableResource();
        }
    }

    @Override
    public XWiringSupport getWiringSupport() {
        return this.wiringSupport;
    }

    @Override
    public void validate() {
        List<Capability> caps = this.getCaplist("osgi.identity");
        if (caps.size() > 1) {
            throw ResolverMessages.MESSAGES.illegalStateMultipleIdentities(caps);
        }
        if (caps.size() == 1) {
            XCapability cap = (XCapability)caps.get(0);
            cap.validate();
            this.identityCapability = cap.adapt(XIdentityCapability.class);
        }
        for (Capability cap : this.getCaplist(null)) {
            if (cap == this.identityCapability) continue;
            try {
                ((XCapability)cap).validate();
            }
            catch (RuntimeException ex) {
                throw new ResourceValidationException(ResolverMessages.MESSAGES.validationInvalidCapability(cap), (Throwable)ex, cap);
            }
        }
        for (Requirement req : this.getReqlist(null)) {
            try {
                ((XRequirement)req).validate();
            }
            catch (RuntimeException ex) {
                throw new ResourceValidationException(ResolverMessages.MESSAGES.validationInvalidRequirement(req), (Throwable)ex, req);
            }
        }
        List<Requirement> reqs = this.getReqlist("osgi.wiring.host");
        this.types = reqs.size() > 0 ? 1 : 0;
    }

    public List<Capability> getCapabilities(String namespace) {
        this.ensureImmutable();
        return Collections.unmodifiableList(this.getCaplist(namespace));
    }

    public List<Requirement> getRequirements(String namespace) {
        this.ensureImmutable();
        return Collections.unmodifiableList(this.getReqlist(namespace));
    }

    @Override
    public XIdentityCapability getIdentityCapability() {
        return this.identityCapability;
    }

    @Override
    public int getTypes() {
        return this.types;
    }

    private List<Capability> getCaplist(String namespace) {
        List<Capability> caplist = this.capabilities.get(namespace);
        if (caplist == null) {
            caplist = new ArrayList<Capability>();
            this.capabilities.put(namespace, caplist);
        }
        return caplist;
    }

    private List<Requirement> getReqlist(String namespace) {
        List<Requirement> reqlist = this.requirements.get(namespace);
        if (reqlist == null) {
            reqlist = new ArrayList<Requirement>();
            this.requirements.put(namespace, reqlist);
        }
        return reqlist;
    }

    public String toString() {
        XIdentityCapability id = this.identityCapability;
        String idstr = id != null ? id.getSymbolicName() + ":" + id.getVersion() : "anonymous";
        return this.getClass().getSimpleName() + "[" + idstr + "]";
    }
}

