/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.infinispan.atomic.Delta;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;

public class ApplyDeltaCommand
extends AbstractDataWriteCommand {
    public static final int COMMAND_ID = 25;
    private Object deltaAwareValueKey;
    private Collection<Object> keys;
    private Delta delta;

    public ApplyDeltaCommand() {
    }

    public ApplyDeltaCommand(Object deltaAwareValueKey, Delta delta, Collection<Object> keys) {
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("At least one key to be locked needs to be specified");
        }
        this.keys = keys;
        this.delta = delta;
        this.deltaAwareValueKey = deltaAwareValueKey;
    }

    public Object getDeltaAwareKey() {
        return this.deltaAwareValueKey;
    }

    public Delta getDelta() {
        return this.delta;
    }

    @Override
    public Object getKey() {
        return this.getDeltaAwareKey();
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        return null;
    }

    @Override
    public byte getCommandId() {
        return 25;
    }

    @Override
    public String toString() {
        return "ApplyDeltaCommand[key=" + this.deltaAwareValueKey + ", delta=" + this.delta + ",keys=" + this.keys + ']';
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.deltaAwareValueKey, this.delta, this.keys};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        if (commandId != 25) {
            throw new IllegalStateException("Unusupported command id:" + commandId);
        }
        int i = 0;
        this.deltaAwareValueKey = args[i++];
        this.delta = (Delta)args[i++];
        this.keys = (List)args[i++];
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitApplyDeltaCommand(ctx, this);
    }

    public Object[] getKeys() {
        return this.keys.toArray();
    }

    public Object[] getCompositeKeys() {
        ArrayList<DeltaCompositeKey> composite = new ArrayList<DeltaCompositeKey>(this.keys.size());
        for (Object k : this.keys) {
            composite.add(new DeltaCompositeKey(this.deltaAwareValueKey, k));
        }
        return composite.toArray();
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        switch (status) {
            case FAILED: 
            case INITIALIZING: 
            case STOPPING: 
            case TERMINATED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplyDeltaCommand)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplyDeltaCommand that = (ApplyDeltaCommand)o;
        return this.keys.equals(that.keys);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.keys != null ? this.keys.hashCode() : 0);
        return result;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    private static final class DeltaCompositeKey
    implements Serializable {
        private static final long serialVersionUID = -8598408570487324159L;
        private final Object deltaAwareValueKey;
        private final Object entryKey;

        public DeltaCompositeKey(Object deltaAwareValueKey, Object entryKey) {
            this.deltaAwareValueKey = deltaAwareValueKey;
            this.entryKey = entryKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.deltaAwareValueKey == null ? 0 : this.deltaAwareValueKey.hashCode());
            result = 31 * result + (this.entryKey == null ? 0 : this.entryKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DeltaCompositeKey)) {
                return false;
            }
            DeltaCompositeKey other = (DeltaCompositeKey)obj;
            if (this.deltaAwareValueKey == null ? other.deltaAwareValueKey != null : !this.deltaAwareValueKey.equals(other.deltaAwareValueKey)) {
                return false;
            }
            return !(this.entryKey == null ? other.entryKey != null : !this.entryKey.equals(other.entryKey));
        }

        public String toString() {
            return "ApplyDeltaCommand#DeltaCompositeKey[deltaAwareValueKey=" + this.deltaAwareValueKey + ", entryKey=" + this.entryKey + ']';
        }
    }
}

