/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.infinispan.config.AbstractFluentConfigurationBean;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationDoc;
import org.infinispan.config.ConfigurationDocRef;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.util.Util;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@ConfigurationDoc(name="loaders", desc="Holds the configuration for cache loaders and stores")
public class CacheLoaderManagerConfig
extends AbstractFluentConfigurationBean
implements FluentConfiguration.LoadersConfig {
    private static final long serialVersionUID = 2210349340378984424L;
    @ConfigurationDocRef(bean=CacheLoaderManagerConfig.class, targetElement="setPassivation")
    protected Boolean passivation = false;
    @ConfigurationDocRef(bean=CacheLoaderManagerConfig.class, targetElement="setPreload")
    protected Boolean preload = false;
    @ConfigurationDocRef(bean=CacheLoaderManagerConfig.class, targetElement="setShared")
    protected Boolean shared = false;
    protected List<CacheLoaderConfig> cacheLoaderConfigs = new LinkedList<CacheLoaderConfig>();

    public CacheLoaderManagerConfig() {
    }

    public CacheLoaderManagerConfig(CacheLoaderConfig clc) {
        this.addCacheLoaderConfig(clc);
    }

    public Boolean isPreload() {
        return this.preload;
    }

    @Override
    public FluentConfiguration.LoadersConfig preload(Boolean preload) {
        this.testImmutability("preload");
        this.preload = preload;
        return this;
    }

    @XmlAttribute
    @Deprecated
    public void setPreload(Boolean preload) {
        this.testImmutability("preload");
        this.preload = preload;
    }

    @Override
    public FluentConfiguration.LoadersConfig passivation(Boolean passivation) {
        this.testImmutability("passivation");
        this.passivation = passivation;
        return this;
    }

    @XmlAttribute
    @Deprecated
    public void setPassivation(Boolean passivation) {
        this.testImmutability("passivation");
        this.passivation = passivation;
    }

    public Boolean isPassivation() {
        return this.passivation;
    }

    @Override
    public FluentConfiguration.LoadersConfig shared(Boolean shared) {
        this.testImmutability("shared");
        this.shared = shared;
        return this;
    }

    @Override
    public FluentConfiguration.LoadersConfig addCacheLoader(CacheLoaderConfig ... configs) {
        for (CacheLoaderConfig config : configs) {
            this.addCacheLoaderConfig(config);
        }
        return this;
    }

    @XmlAttribute
    @Deprecated
    public void setShared(Boolean shared) {
        this.testImmutability("shared");
        this.shared = shared;
    }

    public Boolean isShared() {
        return this.shared;
    }

    @Deprecated
    public FluentConfiguration.LoadersConfig addCacheLoaderConfig(CacheLoaderConfig clc) {
        this.testImmutability("cacheLoaderConfigs");
        this.cacheLoaderConfigs.add(clc);
        return this;
    }

    public List<CacheLoaderConfig> getCacheLoaderConfigs() {
        return this.cacheLoaderConfigs;
    }

    private List<CacheLoaderConfig> getCacheLoaders() {
        this.testImmutability("cacheLoaderConfigs");
        return this.cacheLoaderConfigs;
    }

    @XmlElement(name="loader")
    private FluentConfiguration.LoadersConfig setCacheLoaders(List<CacheLoaderConfig> configs) {
        this.testImmutability("cacheLoaderConfigs");
        this.cacheLoaderConfigs = configs == null ? new LinkedList() : configs;
        return this;
    }

    @Deprecated
    @XmlTransient
    public FluentConfiguration.LoadersConfig setCacheLoaderConfigs(List<CacheLoaderConfig> configs) {
        this.testImmutability("cacheLoaderConfigs");
        this.cacheLoaderConfigs = configs == null ? new LinkedList() : configs;
        return this;
    }

    public CacheLoaderConfig getFirstCacheLoaderConfig() {
        if (this.cacheLoaderConfigs.isEmpty()) {
            return null;
        }
        return this.cacheLoaderConfigs.get(0);
    }

    public Boolean isFetchPersistentState() {
        for (CacheLoaderConfig iclc : this.cacheLoaderConfigs) {
            if (!(iclc instanceof CacheStoreConfig) || !((CacheStoreConfig)iclc).isFetchPersistentState().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected CacheLoaderManagerConfig setConfiguration(Configuration config) {
        super.setConfiguration(config);
        return this;
    }

    public boolean usingChainingCacheLoader() {
        return this.isPassivation() == false && this.cacheLoaderConfigs.size() > 1;
    }

    public String toString() {
        return "CacheLoaderManagerConfig{" + "shared=" + this.shared + ", passivation=" + this.passivation + ", preload='" + this.preload + '\'' + ", cacheLoaderConfigs.size()=" + this.cacheLoaderConfigs.size() + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CacheLoaderManagerConfig) {
            CacheLoaderManagerConfig other = (CacheLoaderManagerConfig)obj;
            return this.passivation.equals(other.passivation) && this.shared.equals(other.shared) && Util.safeEquals(this.preload, other.preload) && Util.safeEquals(this.cacheLoaderConfigs, other.cacheLoaderConfigs);
        }
        return false;
    }

    public void accept(ConfigurationBeanVisitor v) {
        for (CacheLoaderConfig clc : this.cacheLoaderConfigs) {
            clc.accept(v);
        }
        v.visitCacheLoaderManagerConfig(this);
    }

    public int hashCode() {
        int result = 19;
        result = 51 * result + (this.passivation != false ? 0 : 1);
        result = 51 * result + (this.shared != false ? 0 : 1);
        result = 51 * result + (this.preload != false ? 0 : 1);
        result = 51 * result + (this.cacheLoaderConfigs == null ? 0 : this.cacheLoaderConfigs.hashCode());
        return result;
    }

    @Override
    public CacheLoaderManagerConfig clone() throws CloneNotSupportedException {
        CacheLoaderManagerConfig clone = (CacheLoaderManagerConfig)super.clone();
        if (this.cacheLoaderConfigs != null) {
            LinkedList<CacheLoaderConfig> clcs = new LinkedList<CacheLoaderConfig>();
            for (CacheLoaderConfig clc : this.cacheLoaderConfigs) {
                clcs.add(clc.clone());
            }
            clone.cacheLoaderConfigs = clcs;
        }
        return clone;
    }
}

