/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bucket;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.LockSupportCacheStore;
import org.infinispan.loaders.bucket.Bucket;

public abstract class BucketBasedCacheStore
extends LockSupportCacheStore<Integer> {
    @Override
    protected InternalCacheEntry loadLockSafe(Object key, Integer lockingKey) throws CacheLoaderException {
        Bucket bucket = this.loadBucket(lockingKey);
        if (bucket == null) {
            return null;
        }
        InternalCacheEntry se = bucket.getEntry(key);
        if (se != null && se.canExpire() && se.isExpired(System.currentTimeMillis())) {
            return null;
        }
        return se;
    }

    @Override
    protected void storeLockSafe(InternalCacheEntry entry, Integer lockingKey) throws CacheLoaderException {
        Bucket bucket = this.loadBucket(lockingKey);
        if (bucket != null) {
            bucket.addEntry(entry);
            this.updateBucket(bucket);
        } else {
            bucket = new Bucket();
            bucket.setBucketId(lockingKey);
            bucket.addEntry(entry);
            this.insertBucket(bucket);
        }
    }

    @Override
    protected boolean removeLockSafe(Object key, Integer lockingKey) throws CacheLoaderException {
        Bucket bucket = this.loadBucket(lockingKey);
        if (bucket == null) {
            return false;
        }
        boolean success = bucket.removeEntry(key);
        if (success) {
            this.updateBucket(bucket);
        }
        return success;
    }

    @Override
    public Integer getLockFromKey(Object key) {
        return key.hashCode() & 0xFFFFFC00;
    }

    protected void insertBucket(Bucket bucket) throws CacheLoaderException {
        this.updateBucket(bucket);
    }

    @Override
    protected Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException {
        CollectionGeneratingBucketHandler<InternalCacheEntry> g = new CollectionGeneratingBucketHandler<InternalCacheEntry>(){

            @Override
            public boolean consider(Collection<? extends InternalCacheEntry> entries) {
                this.generated.addAll(entries);
                return false;
            }
        };
        this.loopOverBuckets(g);
        return g.generate();
    }

    @Override
    protected Set<InternalCacheEntry> loadLockSafe(final int max) throws CacheLoaderException {
        CollectionGeneratingBucketHandler<InternalCacheEntry> g = new CollectionGeneratingBucketHandler<InternalCacheEntry>(){

            @Override
            public boolean consider(Collection<? extends InternalCacheEntry> entries) {
                Iterator<? extends InternalCacheEntry> i = entries.iterator();
                while (i.hasNext() && this.generated.size() < max) {
                    this.generated.add(i.next());
                }
                return this.generated.size() >= max;
            }
        };
        this.loopOverBuckets(g);
        return g.generate();
    }

    @Override
    protected Set<Object> loadAllKeysLockSafe(final Set<Object> keysToExclude) throws CacheLoaderException {
        CollectionGeneratingBucketHandler<Object> g = new CollectionGeneratingBucketHandler<Object>(){

            @Override
            public boolean consider(Collection<? extends InternalCacheEntry> entries) {
                for (InternalCacheEntry internalCacheEntry : entries) {
                    if (keysToExclude != null && keysToExclude.contains(internalCacheEntry.getKey())) continue;
                    this.generated.add(internalCacheEntry.getKey());
                }
                return false;
            }
        };
        this.loopOverBuckets(g);
        return g.generate();
    }

    protected abstract void loopOverBuckets(BucketHandler var1) throws CacheLoaderException;

    protected abstract void updateBucket(Bucket var1) throws CacheLoaderException;

    protected abstract Bucket loadBucket(Integer var1) throws CacheLoaderException;

    protected abstract class CollectionGeneratingBucketHandler<T>
    implements BucketHandler {
        Set<T> generated = new HashSet<T>();

        protected CollectionGeneratingBucketHandler() {
        }

        public abstract boolean consider(Collection<? extends InternalCacheEntry> var1);

        public Set<T> generate() {
            return this.generated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handle(Bucket bucket) throws CacheLoaderException {
            if (bucket != null) {
                boolean enoughLooping;
                if (bucket.removeExpiredEntries()) {
                    BucketBasedCacheStore.this.upgradeLock(bucket.getBucketId());
                    try {
                        BucketBasedCacheStore.this.updateBucket(bucket);
                    }
                    finally {
                        BucketBasedCacheStore.this.downgradeLock(bucket.getBucketId());
                    }
                }
                if (enoughLooping = this.consider(bucket.getStoredEntries())) {
                    return true;
                }
            }
            return false;
        }
    }

    protected static interface BucketHandler {
        public boolean handle(Bucket var1) throws CacheLoaderException;
    }
}

