/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.AttributeMarshallers;
import org.jboss.as.messaging.BroadcastGroupAdd;
import org.jboss.as.messaging.BroadcastGroupControlHandler;
import org.jboss.as.messaging.BroadcastGroupRemove;
import org.jboss.as.messaging.BroadcastGroupWriteAttributeHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BroadcastGroupDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"broadcast-group");
    public static final PrimitiveListAttributeDefinition CONNECTOR_REFS = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of((String)"connectors", (ModelType)ModelType.STRING).setAllowNull(true)).setValidator((ParameterValidator)new StringLengthValidator(1))).setXmlName("connector-ref")).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.WrappedListAttributeMarshaller(null))).setAllowExpression(false)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition BROADCAST_PERIOD = SimpleAttributeDefinitionBuilder.create((String)"broadcast-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(HornetQDefaultConfiguration.getDefaultBroadcastPeriod())).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowNull(true).setAllowExpression(true).setRestartAllServices().build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.JGROUPS_STACK, CommonAttributes.JGROUPS_CHANNEL, CommonAttributes.SOCKET_BINDING, CommonAttributes.LOCAL_BIND_ADDRESS, CommonAttributes.LOCAL_BIND_PORT, CommonAttributes.GROUP_ADDRESS, CommonAttributes.GROUP_PORT, BROADCAST_PERIOD, CONNECTOR_REFS};
    public static final AttributeDefinition[] ATTRIBUTES_ADDED_IN_1_2_0 = new AttributeDefinition[]{CommonAttributes.JGROUPS_CHANNEL, CommonAttributes.JGROUPS_STACK};
    public static final AttributeDefinition[] ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0 = new AttributeDefinition[]{BROADCAST_PERIOD};
    public static final String GET_CONNECTOR_PAIRS_AS_JSON = "get-connector-pairs-as-json";
    private final boolean registerRuntimeOnly;

    public BroadcastGroupDefinition(boolean registerRuntimeOnly) {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("broadcast-group"), (OperationStepHandler)BroadcastGroupAdd.INSTANCE, (OperationStepHandler)BroadcastGroupRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)BroadcastGroupWriteAttributeHandler.INSTANCE);
        }
        if (this.registerRuntimeOnly) {
            BroadcastGroupControlHandler.INSTANCE.registerAttributes(registry);
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        if (this.registerRuntimeOnly) {
            BroadcastGroupControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
            SimpleOperationDefinition op = new SimpleOperationDefinitionBuilder(GET_CONNECTOR_PAIRS_AS_JSON, this.getResourceDescriptionResolver()).withFlags(EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.RUNTIME_ONLY)).setReplyType(ModelType.STRING).build();
            registry.registerOperationHandler((OperationDefinition)op, (OperationStepHandler)BroadcastGroupControlHandler.INSTANCE);
        }
        super.registerOperations(registry);
    }

    static void validateConnectors(OperationContext context, ModelNode operation, ModelNode connectorRefs) throws OperationFailedException {
        Set<String> availableConnectors = BroadcastGroupDefinition.getAvailableConnectors(context, operation);
        List operationAddress = operation.get("address").asList();
        String broadCastGroup = ((ModelNode)operationAddress.get(operationAddress.size() - 1)).get("broadcast-group").asString();
        for (ModelNode connectorRef : connectorRefs.asList()) {
            String connectorName = connectorRef.asString();
            if (availableConnectors.contains(connectorName)) continue;
            throw MessagingMessages.MESSAGES.wrongConnectorRefInBroadCastGroup(broadCastGroup, connectorName, availableConnectors);
        }
    }

    private static Set<String> getAvailableConnectors(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress hornetqServer = MessagingServices.getHornetQServerPathAddress(address);
        Resource hornetQServerResource = context.readResourceFromRoot(hornetqServer);
        HashSet<String> availableConnectors = new HashSet<String>();
        availableConnectors.addAll(hornetQServerResource.getChildrenNames("in-vm-connector"));
        availableConnectors.addAll(hornetQServerResource.getChildrenNames("remote-connector"));
        availableConnectors.addAll(hornetQServerResource.getChildrenNames("connector"));
        return availableConnectors;
    }
}

