/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.List;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.JMSTopicService;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JMSTopicAdd
extends AbstractAddStepHandler {
    public static final JMSTopicAdd INSTANCE = new JMSTopicAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CommonAttributes.DESTINATION_ENTRIES.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModelNode entries = CommonAttributes.DESTINATION_ENTRIES.resolveModelAttribute(context, model);
        String[] jndiBindings = JMSServices.getJndiBindings(entries);
        this.installServices(verificationHandler, newControllers, name, hqServiceName, serviceTarget, jndiBindings);
    }

    public void installServices(ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, String name, ServiceName hqServiceName, ServiceTarget serviceTarget, String[] jndiBindings) {
        JMSTopicService service = new JMSTopicService(name, jndiBindings);
        ServiceName serviceName = JMSServices.getJmsTopicBaseServiceName(hqServiceName).append(new String[]{name});
        ServiceBuilder serviceBuilder = serviceTarget.addService(serviceName, (Service)service).addDependency(HornetQActivationService.getHornetQActivationServiceName(hqServiceName)).addDependency(JMSServices.getJmsManagerBaseServiceName(hqServiceName), JMSServerManager.class, service.getJmsServer()).setInitialMode(ServiceController.Mode.PASSIVE);
        Services.addServerExecutorDependency((ServiceBuilder)serviceBuilder, service.getExecutorInjector(), (boolean)false);
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = serviceBuilder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }
}

