/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms.bridge;

import java.util.concurrent.ExecutorService;
import javax.transaction.TransactionManager;
import org.hornetq.jms.bridge.JMSBridge;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.manager.WildFlySecurityManager;

class JMSBridgeService
implements Service<JMSBridge> {
    private final JMSBridge bridge;
    private final String bridgeName;
    private final String moduleName;
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();

    public JMSBridgeService(String moduleName, String bridgeName, JMSBridge bridge) {
        if (bridge == null) {
            throw MessagingMessages.MESSAGES.nullVar("bridge");
        }
        this.moduleName = moduleName;
        this.bridgeName = bridgeName;
        this.bridge = bridge;
    }

    public static TransactionManager getTransactionManager(StartContext context) {
        ServiceController service = context.getController().getServiceContainer().getService(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER);
        return service == null ? null : (TransactionManager)service.getValue();
    }

    public synchronized void start(final StartContext context) throws StartException {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    JMSBridgeService.this.bridge.setTransactionManager(JMSBridgeService.getTransactionManager(context));
                    JMSBridgeService.this.startBridge();
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(MessagingMessages.MESSAGES.failedToCreate(e, "JMS Bridge"));
                }
            }
        };
        context.asynchronous();
        ((ExecutorService)this.executorInjector.getValue()).execute(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBridge() throws Exception {
        if (this.moduleName == null) {
            this.bridge.start();
        } else {
            ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            try {
                ModuleIdentifier moduleID = ModuleIdentifier.create((String)this.moduleName);
                Module module = Module.getCallerModuleLoader().loadModule(moduleID);
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
                this.bridge.start();
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
            }
        }
        MessagingLogger.MESSAGING_LOGGER.startedService("JMS Bridge", this.bridgeName);
    }

    public synchronized void stop(final StopContext context) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    JMSBridgeService.this.bridge.stop();
                    MessagingLogger.MESSAGING_LOGGER.stoppedService("JMS Bridge", JMSBridgeService.this.bridgeName);
                    context.complete();
                }
                catch (Exception e) {
                    MessagingLogger.MESSAGING_LOGGER.failedToDestroy("bridge", JMSBridgeService.this.bridgeName);
                }
            }
        };
        context.asynchronous();
        ((ExecutorService)this.executorInjector.getValue()).execute(r);
    }

    public JMSBridge getValue() throws IllegalStateException {
        return this.bridge;
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executorInjector;
    }
}

