/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jaxrs.JaxrsLogger;
import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.resteasy.cdi.ResteasyCdiExtension;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JaxrsCdiIntegrationProcessor
implements DeploymentUnitProcessor {
    public static final String CDI_INJECTOR_FACTORY_CLASS = "org.jboss.resteasy.cdi.CdiInjectorFactory";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        block12: {
            DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
            Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
                return;
            }
            if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
                return;
            }
            DeploymentUnit parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
            WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
            JBossWebMetaData webdata = warMetaData.getMergedJBossWebMetaData();
            try {
                module.getClassLoader().loadClass(CDI_INJECTOR_FACTORY_CLASS);
                if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) break block12;
                JaxrsLogger.JAXRS_LOGGER.debug("Found CDI, adding injector factory class");
                JaxrsCdiIntegrationProcessor.setContextParameter(webdata, "resteasy.injector.factory", CDI_INJECTOR_FACTORY_CLASS);
                DeploymentUnit deploymentUnit2 = parent;
                synchronized (deploymentUnit2) {
                    boolean found = false;
                    List extensions = parent.getAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS);
                    for (Metadata extension : extensions) {
                        if (!(extension.getValue() instanceof ResteasyCdiExtension)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        ClassLoader classLoader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                        try {
                            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)ResteasyCdiExtension.class.getClassLoader());
                            final ResteasyCdiExtension ext = new ResteasyCdiExtension();
                            Metadata<Extension> metadata = new Metadata<Extension>(){

                                public Extension getValue() {
                                    return ext;
                                }

                                public String getLocation() {
                                    return "org.jboss.as.jaxrs.JaxrsExtension";
                                }
                            };
                            parent.addToAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS, (Object)metadata);
                        }
                        finally {
                            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)classLoader);
                        }
                    }
                }
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
    }

    public static void setContextParameter(JBossWebMetaData webdata, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = webdata.getContextParams();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            webdata.setContextParams(params);
        }
        params.add(param);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

