/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import java.util.Locale;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.AddPropertiesUser;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.ErrorState;
import org.jboss.as.domain.management.security.state.PropertyFileFinder;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;

public class PropertyFilePrompt
implements State {
    private ConsoleWrapper theConsole;
    private StateValues stateValues;

    public PropertyFilePrompt(ConsoleWrapper theConsole, StateValues stateValues) {
        this.theConsole = theConsole;
        this.stateValues = stateValues;
        if (theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
        this.theConsole.printf(DomainManagementMessages.MESSAGES.filePrompt(), new Object[0]);
        this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
        String temp = this.theConsole.readLine("(a): ", new Object[0]);
        if (temp == null) {
            this.theConsole.printf(AddPropertiesUser.NEW_LINE, new Object[0]);
            return null;
        }
        switch (this.convertResponse(temp)) {
            case MANAGEMENT: {
                this.stateValues.setManagement(true);
                this.stateValues.setRealm("ManagementRealm");
                return new PropertyFileFinder(this.theConsole, this.stateValues);
            }
            case APPLICATION: {
                this.stateValues.setManagement(false);
                this.stateValues.setRealm("ApplicationRealm");
                return new PropertyFileFinder(this.theConsole, this.stateValues);
            }
        }
        return new ErrorState(this.theConsole, DomainManagementMessages.MESSAGES.invalidChoiceResponse(), this);
    }

    private Option convertResponse(String response) {
        String temp = response.toLowerCase(Locale.ENGLISH);
        if ("".equals(temp) || "a".equals(temp)) {
            return Option.MANAGEMENT;
        }
        if ("b".equals(temp)) {
            return Option.APPLICATION;
        }
        return Option.INVALID;
    }

    private static enum Option {
        MANAGEMENT,
        APPLICATION,
        INVALID;

    }
}

