/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.Iterator;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.modcluster.ModClusterMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ContextHost {
    String webcontext = null;
    String webhost = null;
    int waittime = 10;

    public ContextHost(ModelNode operation) throws OperationFailedException {
        List list = operation.asPropertyList();
        Iterator it = list.iterator();
        this.webcontext = null;
        this.webhost = null;
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (prop.getName().equals("context")) {
                this.webcontext = prop.getValue().toString();
            }
            if (prop.getName().equals("virtualhost")) {
                this.webhost = prop.getValue().toString();
            }
            if (!prop.getName().equals("waittime")) continue;
            this.waittime = Integer.parseInt(ContextHost.RemoveQuotes(prop.getValue().toString()));
        }
        if (this.webcontext == null || this.webhost == null) {
            throw new OperationFailedException(new ModelNode().set(ModClusterMessages.MESSAGES.needContextAndHost()));
        }
        this.webcontext = ContextHost.RemoveQuotes(this.webcontext);
        this.webhost = ContextHost.RemoveQuotes(this.webhost);
        if (this.webcontext.equals("/")) {
            this.webcontext = "";
        }
    }

    public static String RemoveQuotes(String string) {
        if (string.endsWith("\"") && string.startsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

